/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.MultiUserConverter;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.SecurityIndexingUtils;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.List;

@ExperimentalSearchApi
public class MultiUserCustomFieldIndexer
extends BaseCustomFieldIndexer {
    private final MultiUserConverter multiUserConverter;

    private static KeywordField buildCustomField(CustomField customField) {
        return (KeywordField)((AbstractField.Builder)((AbstractField.Builder)((AbstractField.Builder)KeywordField.builder(customField.getId()).stored()).indexed()).docValues()).multiValued().build();
    }

    public MultiUserCustomFieldIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, MultiUserConverter multiUserConverter) {
        super(fieldVisibilityManager, customField, MultiUserCustomFieldIndexer.buildCustomField(customField));
        this.multiUserConverter = multiUserConverter;
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Object value = this.customField.getValue(issue);
        if (value instanceof List) {
            List list = (List)value;
            for (Object o : list) {
                if (!(o instanceof ApplicationUser)) continue;
                ApplicationUser user = (ApplicationUser)o;
                String userId = this.multiUserConverter.getDbString(user);
                this.indexField(collector, userId, issue);
                SecurityIndexingUtils.indexPermissions(collector, issue, this.getId(), userId);
            }
        }
    }

    @Override
    public boolean skipsIndexingNull() {
        return true;
    }
}

