/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.issue.index.indexers.impl;

import com.atlassian.jira.datetime.LocalDate;
import com.atlassian.jira.datetime.LocalDateFactory;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.vdi.CustomFieldPrefetchedData;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.LongField;
import com.atlassian.jira.search.issue.index.indexers.impl.BaseCustomFieldIndexer;
import com.atlassian.jira.web.FieldVisibilityManager;
import java.util.Collection;
import java.util.Date;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExperimentalSearchApi
public class LocalDateIndexer
extends BaseCustomFieldIndexer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LocalDateIndexer.class);
    private final boolean skipIndexingNull;
    private final LongField sortField;

    private static LongField buildCustomField(CustomField customField) {
        return (LongField)((AbstractField.Builder)LongField.builder(customField.getId()).stored()).indexed().build();
    }

    private static LongField buildSortField(CustomField customField) {
        return (LongField)LongField.builder(LocalDateIndexer.sortFieldName(customField)).docValues().build();
    }

    private static String sortFieldName(CustomField customField) {
        return "sort_" + customField.getId();
    }

    public LocalDateIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, boolean skipIndexingNull) {
        super(fieldVisibilityManager, customField, LocalDateIndexer.buildCustomField(customField));
        this.skipIndexingNull = skipIndexingNull;
        this.sortField = LocalDateIndexer.buildSortField(customField);
    }

    @Override
    public String getId() {
        return this.customField.getId();
    }

    @Override
    public Collection<Field> getFields() {
        return Stream.concat(super.getFields().stream(), Stream.of(this.sortField)).toList();
    }

    @Override
    public void indexFields(FieldValueCollector collector, Issue issue, CustomFieldPrefetchedData prefetchedData) {
        Object value = this.customField.getValue(issue);
        if (value instanceof Date) {
            Date date = (Date)value;
            try {
                LocalDate localDate = LocalDateFactory.from(date);
                this.indexField(collector, localDate.getEpochDays(), issue);
                long sortValue = this.isFieldVisibleAndInScope(issue) ? localDate.getEpochDays() : Long.MAX_VALUE;
                collector.add(this.sortField.name(), (Object)sortValue);
            }
            catch (RuntimeException ex) {
                LOGGER.warn("Unable to index custom date field {} ({}) with value: {}", new Object[]{this.customField.getName(), this.customField.getId(), value});
            }
        }
        if (value == null && !this.skipIndexingNull) {
            collector.add(this.sortField.name(), (Object)Long.MAX_VALUE);
        }
    }
}

