/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.Schema;
import com.atlassian.jira.search.TypedField;
import com.atlassian.jira.search.exception.InvalidDocumentFieldException;
import com.atlassian.jira.search.exception.InvalidFieldValueException;
import com.atlassian.jira.search.exception.InvalidMultiValuedFieldException;
import com.atlassian.jira.search.field.FieldValue;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.FieldValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Internal
public class SchemaValidatedFieldValueCollector
implements FieldValueCollector {
    private final Schema schema;
    private final List<FieldValue> values = new ArrayList<FieldValue>();

    public SchemaValidatedFieldValueCollector(Schema schema) {
        this.schema = schema;
    }

    @Override
    public FieldValueCollector add(FieldValue value) {
        this.validate(value);
        this.values.add(value);
        return this;
    }

    private void validate(FieldValue fv) {
        Field field = this.schema.getField(fv.getFieldName()).orElseThrow(() -> new InvalidDocumentFieldException(List.of(fv.getFieldName())));
        this.validateMultiValues(field);
        SchemaValidatedFieldValueCollector.validateFieldType(fv, field);
    }

    private static void validateFieldType(FieldValue fv, Field field) {
        if (field instanceof TypedField) {
            TypedField typed = (TypedField)field;
            Object value = fv.getValue();
            if (!typed.getValueType().isInstance(value)) {
                throw new InvalidFieldValueException(String.format("Value for the field '%s' must be of type %s, but was %s", fv.getFieldName(), typed.getValueType(), value.getClass()));
            }
        }
    }

    private void validateMultiValues(Field field) {
        boolean valueExists;
        if (!field.isMultiValued() && (valueExists = this.values.stream().anyMatch(f -> Objects.equals(field.name(), f.getFieldName())))) {
            throw new InvalidMultiValuedFieldException(List.of(field.name()));
        }
    }

    @Override
    public FieldValues getValues() {
        return FieldValues.copyOf(this.values);
    }
}

