/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.jira.search.DefaultSchema;
import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.TypedField;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.FieldValues;
import com.atlassian.jira.search.field.SchemaValidatedFieldValueCollector;
import java.util.Collections;
import java.util.List;

@ExperimentalSearchApi
public class NestedField
implements TypedField<FieldValues> {
    private final String name;
    private final List<Field> fields;

    public NestedField(String name, Field ... fields) {
        this(name, List.of(fields));
    }

    public NestedField(String name, List<Field> fields) {
        this.name = name;
        this.fields = fields;
    }

    public List<Field> fields() {
        return this.fields;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public <T> T accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Class<FieldValues> getValueType() {
        return FieldValues.class;
    }

    @Override
    public boolean isMultiValued() {
        return true;
    }

    @Override
    public boolean isStored() {
        return false;
    }

    @Override
    public List<FieldValues> get(Document document) {
        return Collections.emptyList();
    }

    public FieldValueCollector createValueCollector() {
        return new SchemaValidatedFieldValueCollector(DefaultSchema.create(this.fields));
    }
}

