/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.search.field.AbstractField;
import com.atlassian.jira.search.field.NumericField;
import java.util.List;

@ExperimentalSearchApi
public final class LongField
extends AbstractField<Long>
implements NumericField {
    private LongField(Builder builder) {
        super(builder);
    }

    @Override
    public <T> T accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public static Builder builder(String fieldName) {
        return new Builder(fieldName);
    }

    @Override
    public List<Long> get(Document document) {
        return document.getNumbers(this.name()).stream().map(Number::longValue).toList();
    }

    public static final class Builder
    extends AbstractField.Builder<LongField> {
        private Builder(String fieldName) {
            super(fieldName);
        }

        @Override
        public LongField build() {
            return new LongField(this);
        }
    }
}

