/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket.datehistogram;

import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;

@ExperimentalSearchApi
public class Interval {
    private final int amount;
    private final TimeUnit unit;

    public Interval(int amount, FixedUnit unit) {
        this.amount = Assertions.isPositive("amount", amount);
        this.unit = Objects.requireNonNull(unit, "unit is required");
    }

    public Interval(CalendarUnit unit) {
        this.amount = 1;
        this.unit = Objects.requireNonNull(unit, "unit is required");
    }

    public int getAmount() {
        return this.amount;
    }

    public TimeUnit getUnit() {
        return this.unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Interval interval = (Interval)o;
        return this.amount == interval.amount && Objects.equals(this.unit, interval.unit);
    }

    public int hashCode() {
        return Objects.hash(this.amount, this.unit);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface TimeUnit {
    }

    public static enum FixedUnit implements TimeUnit
    {
        MILLISECOND,
        SECOND,
        MINUTE,
        HOUR,
        DAY;

    }

    public static enum CalendarUnit implements TimeUnit
    {
        MINUTE,
        HOUR,
        DAY,
        WEEK,
        MONTH,
        QUARTER,
        YEAR;

    }
}

