/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation.bucket;

import com.atlassian.jira.search.aggregation.AggregationsResponse;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.google.common.base.MoreObjects;
import java.util.Objects;
import javax.annotation.Nullable;

@ExperimentalSearchApi
public class Bucket {
    private final String key;
    private final long docCount;
    private final AggregationsResponse aggregations;

    public Bucket(String key, long docCount, @Nullable AggregationsResponse aggregations) {
        this.key = key;
        this.docCount = docCount;
        this.aggregations = (AggregationsResponse)MoreObjects.firstNonNull((Object)aggregations, (Object)AggregationsResponse.EMPTY);
    }

    public String getKey() {
        return this.key;
    }

    public long getDocCount() {
        return this.docCount;
    }

    public AggregationsResponse getAggregations() {
        return this.aggregations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bucket bucket = (Bucket)o;
        return this.docCount == bucket.docCount && Objects.equals(this.key, bucket.key) && Objects.equals(this.aggregations, bucket.aggregations);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.docCount, this.aggregations);
    }
}

