/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.aggregation;

import com.atlassian.jira.search.aggregation.AggregationResult;
import com.atlassian.jira.search.aggregation.bucket.datehistogram.DateHistogramAggregationResult;
import com.atlassian.jira.search.aggregation.bucket.filter.FilterAggregationResult;
import com.atlassian.jira.search.aggregation.bucket.range.RangeAggregationResult;
import com.atlassian.jira.search.aggregation.bucket.terms.TermsAggregationResult;
import com.atlassian.jira.search.aggregation.metric.avg.AvgAggregationResult;
import com.atlassian.jira.search.aggregation.metric.count.ValueCountAggregationResult;
import com.atlassian.jira.search.aggregation.metric.max.MaxAggregationResult;
import com.atlassian.jira.search.aggregation.metric.stats.StatsAggregationResult;
import com.atlassian.jira.search.aggregation.metric.sum.SumAggregationResult;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;

@ExperimentalSearchApi
public class AggregationsResponse {
    public static final AggregationsResponse EMPTY = new AggregationsResponse(Collections.emptyMap());
    private final Map<String, AggregationResult> results;

    public AggregationsResponse(Map<String, AggregationResult> results) {
        this.results = Map.copyOf(results);
    }

    public Map<String, AggregationResult> getResults() {
        return this.results;
    }

    public <T extends AggregationResult> T getResult(String name) {
        return (T)this.results.get(name);
    }

    public TermsAggregationResult getTerms(String name) {
        return (TermsAggregationResult)this.getResult(name);
    }

    public DateHistogramAggregationResult getDateHistogram(String name) {
        return (DateHistogramAggregationResult)this.getResult(name);
    }

    public RangeAggregationResult getRange(String name) {
        return (RangeAggregationResult)this.getResult(name);
    }

    public MaxAggregationResult getMax(String name) {
        return (MaxAggregationResult)this.getResult(name);
    }

    public StatsAggregationResult getStats(String name) {
        return (StatsAggregationResult)this.getResult(name);
    }

    public SumAggregationResult getSum(String name) {
        return (SumAggregationResult)this.getResult(name);
    }

    public AvgAggregationResult getAvg(String name) {
        return (AvgAggregationResult)this.getResult(name);
    }

    public ValueCountAggregationResult getValueCount(String name) {
        return (ValueCountAggregationResult)this.getResult(name);
    }

    public FilterAggregationResult getFilter(String name) {
        return (FilterAggregationResult)this.getResult(name);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregationsResponse that = (AggregationsResponse)o;
        return Objects.equal(this.getResults(), that.getResults());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getResults()});
    }
}

