/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search;

import com.atlassian.jira.search.FieldSort;
import com.atlassian.jira.search.ScoreComputedFieldSort;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

@ExperimentalSearchApi
public class DefaultScoreComputedFieldSort
implements ScoreComputedFieldSort {
    private final String field;
    private final FieldSort.Order order;
    private final Map<String, Long> valueToScore;
    private final long defaultScore;

    public DefaultScoreComputedFieldSort(String field, FieldSort.Order order, Map<String, Long> valueToSortScore) {
        this(field, order, valueToSortScore, Long.MIN_VALUE);
    }

    public DefaultScoreComputedFieldSort(String field, FieldSort.Order order, Map<String, Long> valueToScore, long defaultScore) {
        this.field = field;
        this.order = order;
        this.valueToScore = valueToScore;
        this.defaultScore = defaultScore;
    }

    @Override
    public String field() {
        return this.field;
    }

    @Override
    public long defaultScore() {
        return this.defaultScore;
    }

    @Override
    public Map<String, Long> valueToScore() {
        return this.valueToScore;
    }

    @Override
    public FieldSort.Order order() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultScoreComputedFieldSort that = (DefaultScoreComputedFieldSort)o;
        return Objects.equals(this.field, that.field) && this.order == that.order && Objects.equals(this.valueToScore, that.valueToScore) && Objects.equals(this.defaultScore, that.defaultScore);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.field, this.order, this.valueToScore, this.defaultScore});
    }

    public String toString() {
        String valueToScoreString = this.valueToScore.keySet().stream().sorted().map(key -> key + "=" + String.valueOf(this.valueToScore.get(key))).collect(Collectors.joining(", ", "{", "}"));
        return "DefaultScoreComputedFieldSort{field:" + this.field + ", order:" + String.valueOf((Object)this.order) + ", valueToScore:" + valueToScoreString + ", defaultScore:" + this.defaultScore + "}";
    }
}

