/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.Schema;
import com.atlassian.jira.search.exception.FieldAlreadyExistsException;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
@Internal
public class DefaultSchema
implements Schema {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchema.class);
    private final ImmutableMap<String, Field> map;

    public static Schema create(Collection<Field> fields) {
        return new DefaultSchema(fields);
    }

    DefaultSchema(Collection<Field> fields) {
        Map<String, Field> fieldsMap = this.getValidatedFieldsMap(fields);
        this.map = ImmutableMap.builder().putAll(fieldsMap).build();
    }

    private Map<String, Field> getValidatedFieldsMap(Collection<Field> fields) {
        HashMap<String, Field> fieldsMap = new HashMap<String, Field>();
        Objects.requireNonNull(fields).forEach(field -> {
            Field existingField = fieldsMap.putIfAbsent(field.name(), (Field)field);
            if (existingField != null && !existingField.equals(field)) {
                LOG.warn("Field {} already exists as {}", field, (Object)existingField);
                throw new FieldAlreadyExistsException(String.format("Attempted to add `%s` to the index schema while `%s` already exists", field, existingField));
            }
        });
        return fieldsMap;
    }

    @Override
    public Optional<Field> getField(String name) {
        return Optional.ofNullable((Field)this.map.get((Object)name));
    }

    @Override
    public Collection<Field> getFields() {
        return this.map.values();
    }

    @Override
    public boolean isDefined(Field field) {
        return Objects.requireNonNull(field).equals(this.map.get((Object)field.name()));
    }

    @Override
    public boolean isDefined(String fieldName) {
        return this.map.containsKey((Object)fieldName);
    }

    public String toString() {
        return "DefaultSchema{map=" + String.valueOf(this.map) + "}";
    }
}

