/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.index;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.search.annotations.DeprecatedBySearchApi;
import com.atlassian.jira.search.field.FieldValueCollector;
import com.atlassian.jira.search.field.SystemFields;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.util.BytesRef;

@Internal
public class SecurityIndexingUtils {
    private static final String DELIMITER = "#";
    private static final String PROJECT_PREFIX = "p";
    private static final String SECURITY_LEVEL_PREFIX = "s";

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static void indexPermissions(Document doc, Issue issue) {
        Long projectId = issue.getProjectObject().getId();
        Long issueSecurityLevel = issue.getSecurityLevelId();
        SecurityIndexingUtils.indexProjectPermissionField(doc, SecurityIndexingUtils.generateProjectPermissionFieldContents(projectId));
        if (issueSecurityLevel == null) {
            SecurityIndexingUtils.indexIssueLevelPermissionField(doc, SecurityIndexingUtils.generateIssueLevelPermissionContents(-1L));
        } else {
            SecurityIndexingUtils.indexIssueLevelPermissionField(doc, SecurityIndexingUtils.generateIssueLevelPermissionContents(issueSecurityLevel));
            SecurityIndexingUtils.indexIssueLevelPermissionField(doc, SecurityIndexingUtils.generateIssueLevelPermissionContents(issueSecurityLevel, projectId));
        }
    }

    public static void indexPermissions(FieldValueCollector collector, Issue issue) {
        Long projectId = issue.getProjectObject().getId();
        Long issueSecurityLevel = issue.getSecurityLevelId();
        SecurityIndexingUtils.indexProjectPermissionField(collector, SecurityIndexingUtils.generateProjectPermissionFieldContentString(projectId));
        if (issueSecurityLevel == null) {
            SecurityIndexingUtils.indexIssueLevelPermissionField(collector, SecurityIndexingUtils.generateIssueLevelPermissionContentString(-1L));
        } else {
            SecurityIndexingUtils.indexIssueLevelPermissionField(collector, SecurityIndexingUtils.generateIssueLevelPermissionContentString(issueSecurityLevel));
            SecurityIndexingUtils.indexIssueLevelPermissionField(collector, SecurityIndexingUtils.generateIssueLevelPermissionContentString(issueSecurityLevel, projectId));
        }
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static void indexPermissions(Document doc, Issue issue, String fieldName, String fieldValue) {
        Long projectId = issue.getProjectObject().getId();
        Long issueSecurityLevel = issue.getSecurityLevelId();
        SecurityIndexingUtils.indexProjectPermissionField(doc, SecurityIndexingUtils.generateProjectPermissionFieldContents(projectId, fieldName, fieldValue));
        if (issueSecurityLevel != null) {
            SecurityIndexingUtils.indexIssueLevelPermissionField(doc, SecurityIndexingUtils.generateIssueLevelPermissionContents(issueSecurityLevel, fieldName, fieldValue));
        }
    }

    public static void indexPermissions(FieldValueCollector collector, Issue issue, String fieldName, String fieldValue) {
        Long projectId = issue.getProjectObject().getId();
        Long issueSecurityLevel = issue.getSecurityLevelId();
        SecurityIndexingUtils.indexProjectPermissionField(collector, SecurityIndexingUtils.generateProjectPermissionFieldContentString(projectId, fieldName, fieldValue));
        if (issueSecurityLevel != null) {
            SecurityIndexingUtils.indexIssueLevelPermissionField(collector, SecurityIndexingUtils.generateIssueLevelPermissionContentString(issueSecurityLevel, fieldName, fieldValue));
        }
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static BytesRef generateProjectPermissionFieldContents(Long projectId) {
        return new BytesRef((CharSequence)("p#" + projectId));
    }

    public static String generateProjectPermissionFieldContentString(Long projectId) {
        return "p#" + projectId;
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static BytesRef generateProjectPermissionFieldContents(Long projectId, String fieldName, String fieldValue) {
        return new BytesRef((CharSequence)("p#" + projectId + DELIMITER + fieldName + DELIMITER + fieldValue));
    }

    public static String generateProjectPermissionFieldContentString(Long projectId, String fieldName, String fieldValue) {
        return "p#" + projectId + DELIMITER + fieldName + DELIMITER + fieldValue;
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static BytesRef generateIssueLevelPermissionContents(Long issueSecurityLevel) {
        return new BytesRef((CharSequence)("s#" + issueSecurityLevel));
    }

    public static String generateIssueLevelPermissionContentString(Long issueSecurityLevel) {
        return "s#" + issueSecurityLevel;
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static BytesRef generateIssueLevelPermissionContents(Long issueSecurityLevel, Long projectId) {
        return new BytesRef((CharSequence)("s#" + issueSecurityLevel + "#p#" + projectId));
    }

    public static String generateIssueLevelPermissionContentString(Long issueSecurityLevel, Long projectId) {
        return "s#" + issueSecurityLevel + "#p#" + projectId;
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    public static BytesRef generateIssueLevelPermissionContents(Long issueSecurityLevel, String fieldName, String fieldValue) {
        return new BytesRef((CharSequence)("s#" + issueSecurityLevel + DELIMITER + fieldName + DELIMITER + fieldValue));
    }

    public static String generateIssueLevelPermissionContentString(Long issueSecurityLevel, String fieldName, String fieldValue) {
        return "s#" + issueSecurityLevel + DELIMITER + fieldName + DELIMITER + fieldValue;
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    private static void indexIssueLevelPermissionField(Document doc, BytesRef value) {
        doc.add((IndexableField)new StringField("issue_level_permissions", value, Field.Store.NO));
    }

    private static void indexIssueLevelPermissionField(FieldValueCollector collector, String value) {
        collector.add(SystemFields.ISSUE_LEVEL_PERMISSIONS_FIELD, value);
    }

    @Deprecated(since="10.4", forRemoval=true)
    @DeprecatedBySearchApi
    private static void indexProjectPermissionField(Document doc, BytesRef value) {
        doc.add((IndexableField)new StringField("project_permissions", value, Field.Store.NO));
    }

    private static void indexProjectPermissionField(FieldValueCollector collector, String value) {
        collector.add(SystemFields.PROJECT_PERMISSIONS_FIELD, value);
    }
}

