/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.issue.fields.rest.json.beans.JiraBaseUrls;
import com.atlassian.jira.issue.fields.rest.json.beans.SecurityLevelJsonBean;
import com.atlassian.jira.issue.security.IssueSecurityLevel;
import com.atlassian.jira.issue.security.IssueSecurityLevelScheme;
import com.atlassian.jira.util.JiraUrlCodec;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SecuritySchemeJsonBean {
    @JsonProperty
    @Schema(example="http://www.example.com/jira/rest/api/2/issuesecurityschemes/10000")
    private String self;
    @JsonProperty
    @Schema(example="10000")
    private Long id;
    @JsonProperty
    @Schema(example="My Security Scheme")
    private String name;
    @JsonProperty
    @Schema(example="This is a security scheme")
    private String description;
    @JsonProperty
    @Schema(example="10001")
    private Long defaultSecurityLevelId;
    @JsonProperty
    private Collection<SecurityLevelJsonBean> levels;

    public SecuritySchemeJsonBean(String self, Long id, String name, String description) {
        this.self = self;
        this.id = id;
        this.name = name;
        this.description = description;
    }

    public String getSelf() {
        return this.self;
    }

    public void setSelf(String self) {
        this.self = self;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Long getDefaultSecurityLevelId() {
        return this.defaultSecurityLevelId;
    }

    public void setDefaultSecurityLevelId(Long defaultSecurityLevelId) {
        this.defaultSecurityLevelId = defaultSecurityLevelId;
    }

    public Collection<SecurityLevelJsonBean> getLevels() {
        return this.levels;
    }

    public void setLevels(Collection<SecurityLevelJsonBean> levels) {
        this.levels = levels;
    }

    public static List<SecuritySchemeJsonBean> fromIssueSecuritySchemes(List<IssueSecurityLevelScheme> schemes, final JiraBaseUrls urls) {
        return Arrays.asList((SecuritySchemeJsonBean[])Iterables.toArray((Iterable)Iterables.transform(schemes, (Function)new Function<IssueSecurityLevelScheme, SecuritySchemeJsonBean>(){

            public SecuritySchemeJsonBean apply(IssueSecurityLevelScheme securityLevelScheme) {
                return SecuritySchemeJsonBean.shortBean(securityLevelScheme, urls);
            }
        }), SecuritySchemeJsonBean.class));
    }

    public static SecuritySchemeJsonBean shortBean(IssueSecurityLevelScheme securityLevelScheme, JiraBaseUrls urls) {
        SecuritySchemeJsonBean bean = new SecuritySchemeJsonBean(SecuritySchemeJsonBean.getSelf(urls.restApi2BaseUrl(), JiraUrlCodec.encode(securityLevelScheme.getId().toString())), securityLevelScheme.getId(), securityLevelScheme.getName(), securityLevelScheme.getDescription());
        bean.setDefaultSecurityLevelId(securityLevelScheme.getDefaultSecurityLevelId());
        return bean;
    }

    public static SecuritySchemeJsonBean fullBean(IssueSecurityLevelScheme securityLevelScheme, JiraBaseUrls urls, Collection<IssueSecurityLevel> levels) {
        SecuritySchemeJsonBean bean = SecuritySchemeJsonBean.shortBean(securityLevelScheme, urls);
        bean.setLevels(SecurityLevelJsonBean.shortBeans(levels, urls));
        return bean;
    }

    public static String getSelf(String baseUrl, String encodedId) {
        return baseUrl + "issuesecurityschemes/" + encodedId;
    }
}

