/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.datetime.DateTimeFormatterFactory;
import com.atlassian.jira.issue.comments.PinnedComment;
import com.atlassian.jira.issue.fields.rest.json.CommentBeanFactory;
import com.atlassian.jira.issue.fields.rest.json.beans.CommentJsonBean;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.EmailFormatter;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PinnedCommentJsonBean {
    @JsonProperty
    private CommentJsonBean comment;
    @JsonProperty
    @Schema(example="admin")
    private String pinnedBy;
    @JsonProperty
    @Schema(example="2021-06-01T12:00:00.000+0000")
    private String pinnedDate;

    public static PinnedCommentJsonBean renderedShortBean(PinnedComment pinnedComment, DateTimeFormatterFactory dateTimeFormatterFactory) {
        if (pinnedComment == null) {
            return null;
        }
        PinnedCommentJsonBean bean = new PinnedCommentJsonBean();
        CommentBeanFactory commentBeanFactory = ComponentAccessor.getComponent(CommentBeanFactory.class);
        bean.comment = commentBeanFactory.createBean(pinnedComment.getComment(), ComponentAccessor.getComponent(JiraAuthenticationContext.class).getLoggedInUser(), ComponentAccessor.getComponent(EmailFormatter.class));
        bean.pinnedBy = pinnedComment.getPinnedBy();
        bean.pinnedDate = pinnedComment.getPinnedDate() == null ? "" : dateTimeFormatterFactory.formatter().forLoggedInUser().format(pinnedComment.getPinnedDate());
        return bean;
    }
}

