/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.fields.rest.json.beans;

import com.atlassian.annotations.ExperimentalApi;
import java.util.function.BiFunction;

@ExperimentalApi
public class EntityPropertyBeanSelfFunctions {
    public static BiFunction<Long, String, String> EMPTY_BIFUNCTION = (aLong, s) -> "";

    public static BiFunction<Long, String, String> dashboardItemPropertySelfBiFunction(String dashboardId) {
        return new DashboardItemPropertySelfBiFunction(dashboardId);
    }

    private static class DashboardItemPropertySelfBiFunction
    implements BiFunction<Long, String, String> {
        private final String dashboardId;

        public DashboardItemPropertySelfBiFunction(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("dashboard/%s/items/%d/properties/%s", this.dashboardId, entityId, encodedPropertyKey);
        }
    }

    public static class IssueTypePropertySelfBiFunction
    implements BiFunction<Long, String, String> {
        @Override
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("issuetype/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static class CommentPropertySelfBifFunction
    implements BiFunction<Long, String, String> {
        @Override
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("comment/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static class ProjectPropertySelfBiFunction
    implements BiFunction<Long, String, String> {
        @Override
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("project/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }

    public static class IssuePropertySelfBiFunction
    implements BiFunction<Long, String, String> {
        @Override
        public String apply(Long entityId, String encodedPropertyKey) {
            return String.format("issue/%d/properties/%s", entityId, encodedPropertyKey);
        }
    }
}

