/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.customfields.searchers.information;

import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.searchers.SearcherGroupType;
import com.atlassian.jira.issue.search.searchers.information.GenericSearcherInformation;
import com.atlassian.jira.search.issue.index.indexers.FieldIndexer;
import com.atlassian.jira.util.collect.CollectionUtil;
import com.atlassian.jira.util.dbc.Assertions;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class CustomFieldSearcherInformation
extends GenericSearcherInformation<CustomField> {
    private final List<com.atlassian.jira.issue.index.indexers.FieldIndexer> relatedIndexers;
    private final List<FieldIndexer> indexers;
    private final AtomicReference<CustomField> fieldReference;

    @Deprecated(forRemoval=true, since="10.4")
    public CustomFieldSearcherInformation(String id, String nameKey, List<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer> relatedIndexers, AtomicReference<CustomField> fieldReference) {
        super(id, nameKey, List.of(), fieldReference, SearcherGroupType.CUSTOM);
        this.relatedIndexers = CollectionUtil.copyAsImmutableList(Assertions.notEmpty("relatedIndexers", relatedIndexers));
        this.fieldReference = fieldReference;
        this.indexers = List.of();
    }

    protected CustomFieldSearcherInformation(Builder builder) {
        super(builder.id, builder.nameKey, List.of(), builder.fieldReference, SearcherGroupType.CUSTOM);
        this.fieldReference = builder.fieldReference;
        this.relatedIndexers = List.copyOf((Collection)Assertions.notNull("relatedIndexers", builder.relatedIndexers));
        this.indexers = List.copyOf((Collection)Assertions.containsNoNulls("indexers", builder.indexers));
        if (this.relatedIndexers.isEmpty() && this.indexers.isEmpty()) {
            throw new IllegalArgumentException("Either indexers or relatedIndexers must not be empty");
        }
    }

    @Override
    public List<com.atlassian.jira.issue.index.indexers.FieldIndexer> getRelatedIndexers() {
        CustomField customField = this.fieldReference.get();
        Assertions.stateNotNull("customField", customField);
        List<com.atlassian.jira.issue.index.indexers.FieldIndexer> relatedIndexers = customField.getCustomFieldType().getRelatedIndexers(customField);
        if (relatedIndexers != null && !relatedIndexers.isEmpty()) {
            return relatedIndexers;
        }
        return this.relatedIndexers;
    }

    @Override
    public List<FieldIndexer> getIndexers() {
        CustomField customField = this.fieldReference.get();
        Assertions.stateNotNull("customField", customField);
        List<FieldIndexer> indexers = customField.getCustomFieldType().getIndexers(customField);
        if (!indexers.isEmpty()) {
            return indexers;
        }
        return this.indexers;
    }

    @Override
    public String getNameKey() {
        return this.fieldReference.get().getNameKey();
    }

    public static class Builder {
        private final String id;
        private String nameKey;
        private List<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer> relatedIndexers = List.of();
        private List<? extends FieldIndexer> indexers = List.of();
        private AtomicReference<CustomField> fieldReference;

        public Builder(String id) {
            this.id = id;
        }

        public Builder nameKey(String nameKey) {
            this.nameKey = nameKey;
            return this;
        }

        @Deprecated(forRemoval=true, since="10.4")
        public final Builder relatedIndexers(List<? extends com.atlassian.jira.issue.index.indexers.FieldIndexer> relatedIndexers) {
            this.relatedIndexers = relatedIndexers;
            return this;
        }

        public final Builder indexers(List<? extends FieldIndexer> indexers) {
            this.indexers = indexers;
            return this;
        }

        public Builder fieldReference(AtomicReference<CustomField> fieldReference) {
            this.fieldReference = fieldReference;
            return this;
        }

        public CustomFieldSearcherInformation build() {
            return new CustomFieldSearcherInformation(this);
        }
    }
}

