/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue.comparator;

import com.atlassian.jira.project.version.Version;
import java.util.Comparator;

public class VersionComparator
implements Comparator<Version> {
    public static final Comparator<Version> COMPARATOR = new VersionComparator();

    @Override
    public int compare(Version v1, Version v2) {
        if (v1 == v2) {
            return 0;
        }
        if (v1 == null) {
            return 1;
        }
        if (v2 == null) {
            return -1;
        }
        Long p1 = v1.getProjectId();
        Long p2 = v2.getProjectId();
        if (p1 == null && p2 == null) {
            return 0;
        }
        if (p1 == null) {
            return 1;
        }
        if (p2 == null) {
            return -1;
        }
        int projectComparison = p1.compareTo(p2);
        if (projectComparison != 0) {
            return projectComparison;
        }
        int sequenceComparison = v1.getSequence().compareTo(v2.getSequence());
        if (sequenceComparison != 0) {
            return sequenceComparison;
        }
        return v1.getName().compareTo(v2.getName());
    }
}

