/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.imports.project.mapper;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.imports.project.mapper.ProjectImportIdMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

@Internal
public abstract class AbstractMapper
implements ProjectImportIdMapper {
    private final Set<String> requiredOldIds = new HashSet<String>();
    private final Map<String, String> mappedIds = new ConcurrentHashMap<String, String>();
    private final Map<String, String> oldValuesMap = new HashMap<String, String>();

    @Override
    public Collection<String> getRequiredOldIds() {
        return Collections.unmodifiableSet(this.requiredOldIds);
    }

    @Override
    public Collection<String> getRegisteredOldIds() {
        return Collections.unmodifiableSet(this.oldValuesMap.keySet());
    }

    protected void flagValueAsRequired(String oldId) {
        if (oldId != null) {
            this.requiredOldIds.add(oldId);
        }
    }

    @Override
    public void mapValue(String oldId, String newId) {
        if (newId != null && oldId != null) {
            this.mappedIds.put(oldId, newId);
        }
    }

    @Override
    public String getMappedId(String oldId) {
        if (oldId == null) {
            return null;
        }
        return this.mappedIds.get(oldId);
    }

    @Override
    public Collection<String> getAllMappedIds() {
        return this.mappedIds.values();
    }

    protected void registerOldValue(String oldId, String oldKey) {
        this.oldValuesMap.put(oldId, oldKey);
    }

    @Override
    public String getDisplayName(String oldId) {
        String oldKey = this.oldValuesMap.get(oldId);
        if (oldKey == null) {
            return "[" + oldId + "]";
        }
        return oldKey;
    }

    @Override
    public String getKey(String oldId) {
        return this.oldValuesMap.get(oldId);
    }

    @Override
    public void clearMappedValues() {
        this.mappedIds.clear();
    }
}

