/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.database;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.text.StringEscapeUtils;

public enum DatabaseVendor {
    POSTGRES("Postgres", new PostgreSQLVersionStrategy()),
    ORACLE("Oracle", new OracleVersionStrategy()),
    SQL_SERVER("SQL Server", new MsSqlVersionStrategy()),
    H2("H2", new GenericVersionStrategy()),
    MY_SQL("MySQL", new GenericVersionStrategy()),
    UNSUPPORTED("unsupported database", null),
    FAKE_DATABASE_FOR_TESTING("fakedatabase", new GenericVersionStrategy());

    final String humanReadableName;
    final DatabaseVersionStrategy versionStrategy;

    private DatabaseVendor(String humanReadableName, DatabaseVersionStrategy versionStrategy) {
        this.humanReadableName = humanReadableName;
        this.versionStrategy = versionStrategy;
    }

    public String getHumanReadableName() {
        return this.humanReadableName;
    }

    @Deprecated
    public static String getSQLServerVersionIfExists(String version) {
        try {
            return SQL_SERVER.getVersion(version);
        }
        catch (IllegalArgumentException e) {
            return version;
        }
    }

    public String getVersion(String version) {
        return this.versionStrategy.getVersion(version);
    }

    public String getHumanReadableVersion(String version) {
        try {
            return this.getVersion(version);
        }
        catch (IllegalArgumentException e) {
            return version;
        }
    }

    private static interface DatabaseVersionStrategy {
        public String getVersion(String var1);
    }

    private static class PostgreSQLVersionStrategy
    implements DatabaseVersionStrategy {
        private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*).*");

        private PostgreSQLVersionStrategy() {
        }

        @Override
        public String getVersion(String version) {
            int major;
            Matcher matcher = VERSION_PATTERN.matcher(version);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("the version string retrieved from the database isn't a version number (version string: \"%s\")", StringEscapeUtils.escapeJava((String)version)));
            }
            String[] parts = StringUtils.split((String)matcher.group(1), (String)".");
            int n = major = parts.length > 0 ? NumberUtils.toInt((String)parts[0]) : 0;
            if (major < 10) {
                int minor = parts.length > 1 ? NumberUtils.toInt((String)parts[1]) : 0;
                return major + "." + minor;
            }
            return String.valueOf(major);
        }
    }

    private static class OracleVersionStrategy
    implements DatabaseVersionStrategy {
        private static final Pattern ORACLE_MAJOR_MINOR_PATTERN = Pattern.compile("^.*?(\\d+\\.\\d+)\\.\\d+\\.\\d+.*?", 32);
        private static final Map<String, String> ORACLE_VERSION_ALIASES = ImmutableMap.builder().put((Object)"23.0", (Object)"23ai").put((Object)"19.0", (Object)"19C").put((Object)"18.0", (Object)"18C").put((Object)"12.2", (Object)"12C R2").put((Object)"12.1", (Object)"12C R1").put((Object)"11.2", (Object)"11G R2").put((Object)"11.1", (Object)"11G R1").build();

        private OracleVersionStrategy() {
        }

        @Override
        public String getVersion(String version) {
            Matcher m = ORACLE_MAJOR_MINOR_PATTERN.matcher(version);
            if (!m.matches()) {
                throw new IllegalArgumentException(String.format("the version string retrieved from the database does not seem to contain a version number (version string: \"%s\")", StringEscapeUtils.escapeJava((String)version)));
            }
            return ORACLE_VERSION_ALIASES.entrySet().stream().filter(entry -> m.group(1).equals(entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("the version number retrieved from the database isn't a known version of Oracle Database (version string: \"%s\")", StringEscapeUtils.escapeJava((String)version))));
        }
    }

    private static class MsSqlVersionStrategy
    implements DatabaseVersionStrategy {
        private static final Map<String, String> MSSQL_VERSION_ALIASES = ImmutableMap.builder().put((Object)"16.*", (Object)"2022").put((Object)"15.*", (Object)"2019").put((Object)"14.*", (Object)"2017").put((Object)"13.*", (Object)"2016").put((Object)"Azure 12.*", (Object)"Azure").put((Object)"12.*", (Object)"2014").put((Object)"11.*", (Object)"2012").put((Object)"10.5.+", (Object)"2008 R2").put((Object)"10.[0-4].*", (Object)"2008").put((Object)"9.*", (Object)"2005").put((Object)"8.*", (Object)"2000").build();

        private MsSqlVersionStrategy() {
        }

        @Override
        public String getVersion(String version) {
            return MSSQL_VERSION_ALIASES.entrySet().stream().filter(entry -> version.matches((String)entry.getKey())).map(Map.Entry::getValue).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("the version number retrieved from the database isn't a known version of SQL Server (version string: \"%s\")", StringEscapeUtils.escapeJava((String)version))));
        }
    }

    private static class GenericVersionStrategy
    implements DatabaseVersionStrategy {
        private static final Pattern VERSION_PATTERN = Pattern.compile("(\\d+(\\.\\d+)*).*");

        private GenericVersionStrategy() {
        }

        @Override
        public String getVersion(String version) {
            Matcher matcher = VERSION_PATTERN.matcher(version);
            if (matcher.matches()) {
                String[] parts = StringUtils.split((String)matcher.group(1), (String)".");
                int major = parts.length > 0 ? NumberUtils.toInt((String)parts[0]) : 0;
                int minor = parts.length > 1 ? NumberUtils.toInt((String)parts[1]) : 0;
                return major + "." + minor;
            }
            throw new IllegalArgumentException(String.format("the version number retrieved from the database isn't a version number we expected to get (major.minor.micro) (version string: \"%s\")", StringEscapeUtils.escapeJava((String)version)));
        }
    }
}

