/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.config;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.config.FeatureFlag;
import com.atlassian.jira.util.dbc.Assertions;
import com.google.common.hash.Hashing;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Internal
public class AnalyticsAwareFeatureFlag
extends FeatureFlag {
    private final boolean safeFeatureKey;

    AnalyticsAwareFeatureFlag(String featureKey, boolean defaultOn) {
        this(featureKey, defaultOn, false);
    }

    AnalyticsAwareFeatureFlag(String featureKey, boolean defaultOn, boolean safeFeatureKey) {
        super(featureKey, defaultOn);
        this.safeFeatureKey = safeFeatureKey;
    }

    public boolean isSafeFlagForAnalytics() {
        return this.safeFeatureKey;
    }

    public String getSafeFeatureKey() {
        if (this.isSafeFlagForAnalytics()) {
            return this.featureKey();
        }
        return Hashing.sha256().hashString((CharSequence)this.featureKey(), StandardCharsets.UTF_8).toString();
    }

    public AnalyticsAwareFeatureFlag safeKey() {
        return new AnalyticsAwareFeatureFlag(this.featureKey(), this.isOnByDefault(), true);
    }

    public AnalyticsAwareFeatureFlag unsafeKey() {
        return new AnalyticsAwareFeatureFlag(this.featureKey(), this.isOnByDefault(), false);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnalyticsAwareFeatureFlag flag = (AnalyticsAwareFeatureFlag)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.safeFeatureKey, flag.safeFeatureKey).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.safeFeatureKey).toHashCode();
    }

    public static AnalyticsAwareFeatureFlag featureFlag(String featureKey) {
        Assertions.notNull(featureKey);
        return new AnalyticsAwareFeatureFlag(featureKey, false);
    }

    public static AnalyticsAwareFeatureFlag safeFeatureFlag(String featureKey) {
        Assertions.notNull(featureKey);
        return new AnalyticsAwareFeatureFlag(featureKey, false, true);
    }

    public static AnalyticsAwareFeatureFlag convertToSafeFeatureFlag(FeatureFlag featureFlag) {
        Assertions.notNull(featureFlag);
        return new AnalyticsAwareFeatureFlag(featureFlag.featureKey(), featureFlag.isOnByDefault(), true);
    }

    public static FeatureFlag convertToUnsafeFeatureFlag(FeatureFlag featureFlag) {
        Assertions.notNull(featureFlag);
        if (featureFlag instanceof AnalyticsAwareFeatureFlag) {
            return ((AnalyticsAwareFeatureFlag)featureFlag).unsafeKey();
        }
        return featureFlag;
    }

    public static AnalyticsAwareFeatureFlag convertToAnalyticsAware(FeatureFlag featureFlag) {
        if (featureFlag instanceof AnalyticsAwareFeatureFlag) {
            return (AnalyticsAwareFeatureFlag)featureFlag;
        }
        return new AnalyticsAwareFeatureFlag(featureFlag.featureKey(), featureFlag.isOnByDefault(), false);
    }
}

