/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.bc.issue.search;

import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.search.SearchContext;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.issue.search.SearchStreamResults;
import com.atlassian.jira.jql.context.QueryContext;
import com.atlassian.jira.search.Query;
import com.atlassian.jira.search.annotations.ExperimentalSearchApi;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.MessageSet;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.bean.PagerFilter;
import java.util.Objects;
import javax.annotation.Nonnull;

@PublicApi
public interface SearchService {
    public SearchResults<Issue> search(ApplicationUser var1, com.atlassian.query.Query var2, PagerFilter var3) throws SearchException;

    public SearchResults<Issue> search(ApplicationUser var1, com.atlassian.query.Query var2, Query var3, PagerFilter var4) throws SearchException;

    @ExperimentalSearchApi
    public SearchStreamResults<Issue> streamSearch(ApplicationUser var1, com.atlassian.query.Query var2) throws SearchException;

    public SearchResults<Issue> searchOverrideSecurity(ApplicationUser var1, com.atlassian.query.Query var2, PagerFilter var3) throws SearchException;

    public long searchCount(ApplicationUser var1, com.atlassian.query.Query var2) throws SearchException;

    public long searchCount(ApplicationUser var1, com.atlassian.query.Query var2, Long var3) throws SearchException;

    public long searchCountOverrideSecurity(ApplicationUser var1, com.atlassian.query.Query var2) throws SearchException;

    public String getQueryString(ApplicationUser var1, com.atlassian.query.Query var2);

    @Nonnull
    public String getIssueSearchPath(ApplicationUser var1, @Nonnull IssueSearchParameters var2);

    public ParseResult parseQuery(ApplicationUser var1, String var2);

    @Nonnull
    public MessageSet validateQuery(ApplicationUser var1, @Nonnull com.atlassian.query.Query var2);

    @Nonnull
    public MessageSet validateQuery(ApplicationUser var1, @Nonnull com.atlassian.query.Query var2, Long var3);

    public boolean doesQueryFitFilterForm(ApplicationUser var1, com.atlassian.query.Query var2);

    public QueryContext getQueryContext(ApplicationUser var1, com.atlassian.query.Query var2);

    public QueryContext getSimpleQueryContext(ApplicationUser var1, com.atlassian.query.Query var2);

    public SearchContext getSearchContext(ApplicationUser var1, com.atlassian.query.Query var2);

    public String getJqlString(com.atlassian.query.Query var1);

    public String getGeneratedJqlString(com.atlassian.query.Query var1);

    public com.atlassian.query.Query sanitiseSearchQuery(ApplicationUser var1, com.atlassian.query.Query var2);

    @PublicApi
    public static final class IssueSearchParameters {
        private final com.atlassian.query.Query query;
        private final Long filterId;

        private IssueSearchParameters(com.atlassian.query.Query query, Long filterId) {
            this.query = query;
            this.filterId = filterId;
        }

        public com.atlassian.query.Query query() {
            return this.query;
        }

        public Long filterId() {
            return this.filterId;
        }

        public static Builder builder() {
            return new Builder();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            IssueSearchParameters that = (IssueSearchParameters)o;
            return Objects.equals(this.query, that.query) && Objects.equals(this.filterId, that.filterId);
        }

        public int hashCode() {
            return Objects.hash(this.query, this.filterId);
        }

        public static class Builder {
            private com.atlassian.query.Query query;
            private Long filterId;

            public Builder query(com.atlassian.query.Query query) {
                this.query = query;
                return this;
            }

            public Builder filterId(Long filterId) {
                this.filterId = filterId;
                return this;
            }

            public IssueSearchParameters build() {
                return new IssueSearchParameters(this.query, this.filterId);
            }
        }
    }

    @PublicApi
    public static final class ParseResult {
        private com.atlassian.query.Query query;
        private MessageSet errors;

        public ParseResult(com.atlassian.query.Query query, MessageSet errors) {
            this.query = query;
            this.errors = Assertions.notNull("errors", errors);
        }

        public com.atlassian.query.Query getQuery() {
            return this.query;
        }

        public MessageSet getErrors() {
            return this.errors;
        }

        public boolean isValid() {
            return !this.errors.hasAnyErrors();
        }
    }
}

