/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.util.lang;

import com.atlassian.jira.util.dbc.Assertions;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public final class Pair<F, S> {
    private final F first;
    private final S second;

    public static <U, V> Pair<U, V> of(U first, V second) {
        return Pair.strictPairOf(first, second);
    }

    public static <U, V> Pair<U, V> strictPairOf(@Nonnull U first, @Nonnull V second) {
        return new Pair<U, V>(Assertions.notNull("first", first), Assertions.notNull("second", second));
    }

    public static <U, V> Pair<U, V> nicePairOf(@Nullable U first, @Nullable V second) {
        return new Pair<U, V>(first, second);
    }

    private Pair(F first, S second) {
        this.first = first;
        this.second = second;
    }

    public F first() {
        return this.first;
    }

    public S second() {
        return this.second;
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair that = (Pair)o;
        return Objects.equals(this.first, that.first) && Objects.equals(this.second, that.second);
    }

    public String toString() {
        return "Pair[first=" + String.valueOf(this.first) + ", second=" + String.valueOf(this.second) + "]";
    }
}

