/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.query;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.field.KeywordField;
import com.atlassian.jira.search.query.TermRangeQuery;
import java.util.Objects;

@Internal
public final class DefaultTermRangeQuery
implements TermRangeQuery {
    private final KeywordField field;
    private final String lower;
    private final String upper;
    private final boolean includeLower;
    private final boolean includeUpper;

    public DefaultTermRangeQuery(KeywordField field, String lower, String upper, boolean includeLower, boolean includeUpper) {
        this.field = Objects.requireNonNull(field);
        this.lower = Objects.requireNonNull(lower);
        this.upper = Objects.requireNonNull(upper);
        this.includeLower = includeLower;
        this.includeUpper = includeUpper;
    }

    @Override
    public KeywordField field() {
        return this.field;
    }

    @Override
    public String lower() {
        return this.lower;
    }

    @Override
    public String upper() {
        return this.upper;
    }

    @Override
    public boolean includeLower() {
        return this.includeLower;
    }

    @Override
    public boolean includeUpper() {
        return this.includeUpper;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DefaultTermRangeQuery that = (DefaultTermRangeQuery)obj;
        return Objects.equals(this.field, that.field) && Objects.equals(this.lower, that.lower) && Objects.equals(this.upper, that.upper) && this.includeLower == that.includeLower && this.includeUpper == that.includeUpper;
    }

    public int hashCode() {
        return Objects.hash(this.field, this.lower, this.upper, this.includeLower, this.includeUpper);
    }

    public String toString() {
        return "DefaultTermRangeQuery[field=" + String.valueOf(this.field) + ", lower=" + this.lower + ", upper=" + this.upper + ", includeLower=" + this.includeLower + ", includeUpper=" + this.includeUpper + "]";
    }
}

