/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.index;

import java.util.Objects;
import java.util.Optional;

public final class DeleteRequest {
    private final String documentId;
    private final Long documentVersion;

    private DeleteRequest(Builder builder) {
        this.documentId = builder.documentId;
        this.documentVersion = builder.documentVersion;
    }

    public String getDocumentId() {
        return this.documentId;
    }

    public Optional<Long> getDocumentVersion() {
        return Optional.ofNullable(this.documentVersion);
    }

    public static Builder builder(String documentId) {
        return new Builder(documentId);
    }

    public static Builder builder(String documentId, long version) {
        return new Builder(documentId, version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeleteRequest that = (DeleteRequest)o;
        return Objects.equals(this.documentId, that.documentId) && Objects.equals(this.documentVersion, that.documentVersion);
    }

    public int hashCode() {
        return Objects.hash(this.documentId, this.documentVersion);
    }

    public static class Builder {
        private final String documentId;
        private final Long documentVersion;

        public Builder(String documentId) {
            this(documentId, null);
        }

        public Builder(String documentId, Long version) {
            this.documentId = Objects.requireNonNull(documentId, "documentId");
            this.documentVersion = version;
        }

        public DeleteRequest build() {
            return new DeleteRequest(this);
        }
    }
}

