/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.search.field;

import com.atlassian.annotations.Internal;
import com.atlassian.jira.search.Document;
import com.atlassian.jira.search.Field;
import com.atlassian.jira.search.FieldVisitor;
import com.atlassian.jira.search.field.FieldValue;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Internal
public class JoinField
implements Field {
    private final String childType;
    private final String parentType;

    public JoinField(String parentType, String childType) {
        this.parentType = Objects.requireNonNull(parentType, "parentType");
        this.childType = Objects.requireNonNull(childType, "childType");
    }

    @Override
    public <T> Optional<T> accept(FieldVisitor<T> visitor) {
        return visitor.visit(this);
    }

    public FieldValue createChild(String parentId) {
        return new FieldValue(this, parentId);
    }

    public FieldValue createParent() {
        return new FieldValue(this, null);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JoinField)) {
            return false;
        }
        JoinField joinField = (JoinField)o;
        return Objects.equals(this.getParentType(), joinField.getParentType()) && Objects.equals(this.getChildType(), joinField.getChildType());
    }

    public List<String> get(Document doc) {
        return doc.getValues(this);
    }

    public String getChildType() {
        return this.childType;
    }

    public String getParentType() {
        return this.parentType;
    }

    public int hashCode() {
        return Objects.hash("_join", this.getParentType(), this.getChildType());
    }

    @Override
    public boolean isIndexed() {
        return true;
    }

    @Override
    public String name() {
        return "_join_" + this.parentType + "_" + this.childType;
    }

    @Override
    public boolean isSortable() {
        return false;
    }

    @Override
    public boolean isStored() {
        return true;
    }

    public String toString() {
        return "JoinField{parentType=" + this.parentType + ", childType=" + this.childType + "}";
    }
}

