/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.plugin.webfragment;

import com.atlassian.jira.component.ComponentAccessor;
import com.atlassian.jira.plugin.webfragment.model.JiraHelper;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.I18nHelper;
import java.util.Map;
import java.util.Optional;

public final class JiraWebContext {
    public static final String CONTEXT_KEY_USER = "user";
    public static final String CONTEXT_KEY_USERNAME = "username";
    public static final String CONTEXT_KEY_HELPER = "helper";
    public static final String CONTEXT_KEY_LOCATION = "location";
    public static final String CONTEXT_KEY_I18N = "i18n";
    private final Map<String, Object> context;

    private JiraWebContext(Map<String, Object> context) {
        this.context = context;
    }

    public static JiraWebContext from(Map<String, Object> context) {
        return new JiraWebContext(context);
    }

    public static Map<String, Object> makeContext(ApplicationUser remoteUser, JiraHelper jiraHelper) {
        Map<String, Object> params = jiraHelper.getContextParams();
        params.put(CONTEXT_KEY_USER, remoteUser);
        params.put(CONTEXT_KEY_HELPER, jiraHelper);
        return params;
    }

    public Optional<ApplicationUser> getUser() {
        return Optional.ofNullable(this.get(CONTEXT_KEY_USER, ApplicationUser.class).orElseGet(this::getUserByUsername));
    }

    private ApplicationUser getUserByUsername() {
        return this.getUsername().map(username -> ComponentAccessor.getUserManager().getUserByName((String)username)).orElse(null);
    }

    public Optional<JiraHelper> getHelper() {
        return this.get(CONTEXT_KEY_HELPER, JiraHelper.class);
    }

    public Optional<I18nHelper> getI18n() {
        return this.get(CONTEXT_KEY_I18N, I18nHelper.class);
    }

    public Optional<String> getUsername() {
        return this.get(CONTEXT_KEY_USERNAME, String.class);
    }

    public Optional<String> getLocation() {
        return this.get(CONTEXT_KEY_LOCATION, String.class);
    }

    public <T> Optional<T> get(String key, Class<T> type) {
        Object value = this.context.get(key);
        return type.isInstance(value) ? Optional.ofNullable(type.cast(value)) : Optional.empty();
    }
}

