/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.issue;

import com.atlassian.annotations.ExperimentalApi;
import com.atlassian.annotations.PublicApi;
import com.atlassian.jira.exception.AttachmentNotFoundException;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.exception.RemoveException;
import com.atlassian.jira.issue.AttachmentError;
import com.atlassian.jira.issue.AttachmentsBulkOperationResult;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.attachment.Attachment;
import com.atlassian.jira.issue.attachment.AttachmentReadException;
import com.atlassian.jira.issue.attachment.ConvertTemporaryAttachmentParams;
import com.atlassian.jira.issue.attachment.CreateAttachmentParamsBean;
import com.atlassian.jira.issue.attachment.NoAttachmentDataException;
import com.atlassian.jira.issue.attachment.TemporaryAttachmentId;
import com.atlassian.jira.issue.history.ChangeItemBean;
import com.atlassian.jira.task.context.Context;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.io.InputStreamConsumer;
import com.atlassian.jira.web.action.issue.TemporaryAttachmentsMonitor;
import com.atlassian.jira.web.util.AttachmentException;
import io.atlassian.fugue.Either;
import java.io.IOException;
import java.io.InputStream;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@PublicApi
public interface AttachmentManager {
    public static final String THUMBS_SUBDIR = "thumbs";

    public Attachment getAttachment(Long var1) throws DataAccessException, AttachmentNotFoundException;

    public List<Attachment> getAttachments(Issue var1) throws DataAccessException;

    public List<Attachment> getAttachments(Issue var1, Comparator<? super Attachment> var2) throws DataAccessException;

    public ChangeItemBean createAttachment(CreateAttachmentParamsBean var1) throws AttachmentException;

    public Either<AttachmentError, ChangeItemBean> tryCreateAttachment(CreateAttachmentParamsBean var1);

    public void deleteAttachment(Attachment var1) throws RemoveException;

    public boolean isScreenshotAppletEnabled();

    public boolean isScreenshotAppletSupportedByOS();

    @Deprecated
    public List<ChangeItemBean> convertTemporaryAttachments(@Nullable ApplicationUser var1, Issue var2, List<Long> var3, TemporaryAttachmentsMonitor var4) throws AttachmentException;

    @Deprecated
    public AttachmentsBulkOperationResult<ChangeItemBean> tryConvertTemporaryAttachments(@Nullable ApplicationUser var1, Issue var2, List<Long> var3, TemporaryAttachmentsMonitor var4);

    public Attachment setThumbnailable(Attachment var1, boolean var2);

    public Attachment setZip(Attachment var1, boolean var2);

    public <T> T streamAttachmentContent(@Nonnull Attachment var1, InputStreamConsumer<T> var2) throws IOException;

    public void moveAttachments(Issue var1, String var2);

    public Either<AttachmentError, Attachment> copyAttachment(Attachment var1, @Nullable ApplicationUser var2, String var3);

    public Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Issue var1, @Nullable ApplicationUser var2, String var3);

    public Map<Long, Either<AttachmentError, Attachment>> copyAttachments(Context var1, Issue var2, @Nullable ApplicationUser var3, String var4);

    public TemporaryAttachmentId createTemporaryAttachment(InputStream var1, long var2);

    public void deleteTemporaryAttachment(TemporaryAttachmentId var1);

    public Either<AttachmentError, ChangeItemBean> convertTemporaryAttachment(ConvertTemporaryAttachmentParams var1);

    @ExperimentalApi
    public <T> T streamTemporaryAttachmentContent(@Nonnull TemporaryAttachmentId var1, InputStreamConsumer<T> var2) throws AttachmentReadException, NoAttachmentDataException;
}

