/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.rest.resources;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.jira.UserHelper;
import com.atlassian.jconnect.rest.entities.AdminForm;
import com.atlassian.jconnect.rest.entities.ProjectStatusEntity;
import com.atlassian.jconnect.util.Either;
import com.atlassian.jira.bc.ServiceOutcome;
import com.atlassian.jira.bc.project.ProjectService;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.jira.util.lang.Pair;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/admin")
public class JMCAdminResource {
    private ProjectService jiraProjectService;
    private JMCProjectService jmcProjectService;
    private UserManager userManager;
    private UserHelper userHelper;
    private PermissionManager permissionManager;
    private static final Logger log = LoggerFactory.getLogger(JMCAdminResource.class);

    public JMCAdminResource(PermissionManager permissionManager, UserManager userManager, UserHelper userHelper, ProjectService jiraProjectService, JMCProjectService projectService) {
        this.jiraProjectService = jiraProjectService;
        this.jmcProjectService = projectService;
        this.userManager = userManager;
        this.userHelper = userHelper;
        this.permissionManager = permissionManager;
    }

    @GET
    @Path(value="projectStatus")
    @Produces(value={"application/json"})
    public Response projectStatus(@QueryParam(value="projectId") Long projectId) throws Exception {
        Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> result = this.validateProject(projectId);
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        Project project = (Project)result.getLeft().first();
        boolean enabled = this.jmcProjectService.isJiraConnectProject(project);
        String apiKey = enabled ? this.jmcProjectService.lookupApiKeyFor(project) : "";
        boolean reindexRequired = false;
        boolean apiKeyActive = this.jmcProjectService.isApiKeyEnabledFor(project);
        boolean crashesEnabled = this.jmcProjectService.isCrashesEnabledFor(project);
        return Response.ok((Object)new ProjectStatusEntity(project.getId(), project.getKey(), enabled, apiKey, false, apiKeyActive, crashesEnabled)).build();
    }

    @POST
    @Path(value="toggleOnOff")
    @Produces(value={"application/json"})
    public Response enableProject(AdminForm form) throws Exception {
        Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> result = this.validateProject(form.getProjectId());
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        ApplicationUser user = (ApplicationUser)result.getLeft().second();
        Project project = (Project)result.getLeft().first();
        boolean enabled = this.jmcProjectService.toggleForJiraConnect(project);
        String apiKey = enabled ? this.jmcProjectService.generateOrRetrieveAPIKeyFor(project) : "";
        boolean reindexRequired = this.jmcProjectService.reindexRequiredFor(project, user);
        boolean apiKeyActive = this.jmcProjectService.isApiKeyEnabledFor(project);
        boolean crashesEnabled = this.jmcProjectService.isCrashesEnabledFor(project);
        return Response.ok((Object)new ProjectStatusEntity(project.getId(), project.getKey(), enabled, apiKey, reindexRequired, apiKeyActive, crashesEnabled)).build();
    }

    @POST
    @Path(value="resetApiKey")
    @Produces(value={"application/json"})
    public Response resetApiKey(AdminForm form) throws Exception {
        Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> result = this.validateProject(form.getProjectId());
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        Project project = (Project)result.getLeft().first();
        String newApiKey = this.jmcProjectService.generateApiKeyFor(project);
        boolean enabled = this.jmcProjectService.isJiraConnectProject(project);
        boolean crashesEnabled = this.jmcProjectService.isCrashesEnabledFor(project);
        boolean apiKeyActive = this.jmcProjectService.isApiKeyEnabledFor(project);
        return Response.ok((Object)new ProjectStatusEntity(form.getProjectId(), project.getKey(), enabled, newApiKey, false, apiKeyActive, crashesEnabled)).build();
    }

    @POST
    @Path(value="setApiKeyActiveStatus")
    @Produces(value={"application/json"})
    public Response toggleApiKey(AdminForm form) throws Exception {
        Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> result = this.validateProject(form.getProjectId());
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        Project project = (Project)result.getLeft().first();
        boolean jiraConnectProject = this.jmcProjectService.isJiraConnectProject(project);
        boolean crashesEnabled = this.jmcProjectService.isCrashesEnabledFor(project);
        boolean apiKeyActive = this.jmcProjectService.toggleApiKeyFor(project, form.isActive());
        return Response.ok((Object)new ProjectStatusEntity(form.getProjectId(), project.getKey(), jiraConnectProject, null, false, apiKeyActive, crashesEnabled)).build();
    }

    @POST
    @Path(value="setCrashesEnabledStatus")
    @Produces(value={"application/json"})
    public Response toggleCrashesEnabledStatus(AdminForm form) throws Exception {
        Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> result = this.validateProject(form.getProjectId());
        if (result.getRight() != null) {
            return result.getRight().build();
        }
        Project project = (Project)result.getLeft().first();
        boolean jiraConnectProject = this.jmcProjectService.isJiraConnectProject(project);
        boolean apiKeyActive = this.jmcProjectService.isApiKeyEnabledFor(project);
        boolean crashesEnabled = this.jmcProjectService.toggleCrashesFor(project, form.isCrashesEnabled());
        return Response.ok((Object)new ProjectStatusEntity(form.getProjectId(), project.getKey(), jiraConnectProject, null, false, apiKeyActive, crashesEnabled)).build();
    }

    @GET
    @Path(value="stats")
    @Produces(value={"application/json"})
    public Response getStatistics() {
        String remoteUsername = this.userManager.getRemoteUsername();
        ApplicationUser user = this.userHelper.getApplicationUser(remoteUsername);
        if (!this.userManager.isSystemAdmin(remoteUsername)) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Only System Administrators may access this resource").build();
        }
        ServiceOutcome allProjects = this.jiraProjectService.getAllProjects(user);
        List projects = (List)allProjects.getReturnedValue();
        int jmcProjectCount = 0;
        for (Project project : projects) {
            jmcProjectCount += this.jmcProjectService.isJiraConnectProject(project) ? 1 : 0;
        }
        long jmcIssueCount = this.jmcProjectService.countJMCIssues(user);
        JSONObject json = new JSONObject();
        try {
            json.put("projectCount", jmcProjectCount);
            json.put("issueCount", jmcIssueCount);
            return Response.ok((Object)json.toString(), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
        }
        catch (JSONException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).build();
        }
    }

    private Either<Pair<Project, ApplicationUser>, Response.ResponseBuilder> validateProject(Long projectId) {
        String remoteUsername = this.userManager.getRemoteUsername();
        if (projectId == null) {
            return Either.right(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"Missing projectId parameter in request"));
        }
        ApplicationUser remoteUser = this.userHelper.getApplicationUser(remoteUsername);
        Project project = this.jiraProjectService.getProjectById(remoteUser, projectId).getProject();
        if (project == null) {
            return Either.right(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)("Project with ID: " + projectId + " not found")));
        }
        if (remoteUser == null || !this.userHasAdminPermission(remoteUsername, project, remoteUser)) {
            return Either.right(Response.status((Response.Status)Response.Status.UNAUTHORIZED).entity((Object)"Permission denied: Admins only."));
        }
        return Either.left(Pair.of((Object)project, (Object)remoteUser));
    }

    private boolean userHasAdminPermission(String remoteUsername, Project project, ApplicationUser user) {
        return this.permissionManager.hasPermission(23, project, user) || this.permissionManager.hasPermission(0, user) || this.userManager.isSystemAdmin(remoteUsername);
    }
}

