/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.tabpanel;

import com.atlassian.jconnect.jira.customfields.BuiltInField;
import com.atlassian.jconnect.jira.customfields.CustomFieldHelper;
import com.atlassian.jconnect.jira.customfields.IssueLocation;
import com.atlassian.jconnect.jira.customfields.Location;
import com.atlassian.jconnect.jira.tabpanel.AbstractFragment;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.project.browse.BrowseContext;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.ErrorCollection;
import com.atlassian.jira.util.SimpleErrorCollection;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.velocity.VelocityManager;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class GoogleMapsFragment
extends AbstractFragment {
    private final CustomFieldHelper customFieldHelper;
    private final SearchService searchService;
    private static final int MAX_LATEST_ISSUES = 500;

    public GoogleMapsFragment(VelocityManager velocityManager, ApplicationProperties applicationProperites, JiraAuthenticationContext jiraAuthenticationContext, CustomFieldHelper customFieldHelper, SearchService searchService) {
        super(velocityManager, applicationProperites, jiraAuthenticationContext);
        this.customFieldHelper = customFieldHelper;
        this.searchService = searchService;
    }

    @Override
    public Map<String, Object> createVelocityParams(BrowseContext ctx) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        SimpleErrorCollection errors = new SimpleErrorCollection();
        List<IssueLocation> issues = this.collectIssueLocations(ctx, (ErrorCollection)errors);
        params.put("errors", errors);
        params.put("issues", issues);
        params.put("firstIssue", issues.isEmpty() ? null : issues.get(0));
        return params;
    }

    private List<IssueLocation> collectIssueLocations(BrowseContext ctx, ErrorCollection errors) {
        String jql = "project=" + ctx.getProject().getKey() + " order by createdDate";
        ApplicationUser loggedInUser = this.getJiraAuthenticationContext().getLoggedInUser();
        SearchService.ParseResult parseResult = this.searchService.parseQuery(loggedInUser, jql);
        if (!parseResult.isValid()) {
            errors.addErrorMessages((Collection)parseResult.getErrors().getErrorMessages());
        } else {
            try {
                SearchResults results = this.searchService.search(loggedInUser, parseResult.getQuery(), PagerFilter.newPageAlignedFilter((int)0, (int)500));
                return Lists.transform((List)results.getIssues(), (Function)new Function<Issue, IssueLocation>(){

                    public IssueLocation apply(@Nullable Issue from) {
                        if (from != null) {
                            Location location = (Location)from.getCustomFieldValue(GoogleMapsFragment.this.getLocationField());
                            return location != null ? new IssueLocation(location, from) : null;
                        }
                        return null;
                    }
                });
            }
            catch (SearchException se) {
                errors.addErrorMessage(se.getLocalizedMessage());
            }
        }
        return Collections.emptyList();
    }

    @Override
    public String getId() {
        return "googlemaps";
    }

    @Override
    public boolean showFragment(BrowseContext browseContext) {
        return this.customFieldHelper.containsField(browseContext.getProject(), this.getLocationField());
    }

    private CustomField getLocationField() {
        return this.customFieldHelper.initBuiltInCustomField(BuiltInField.LOCATION);
    }
}

