/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.Location;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.converters.DoubleConverter;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.index.indexers.impl.AbstractCustomFieldIndexer;
import com.atlassian.jira.util.dbc.Assertions;
import com.atlassian.jira.web.FieldVisibilityManager;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;

public class LocationIndexer
extends AbstractCustomFieldIndexer {
    private final CustomField field;
    private final DoubleConverter doubleConverter;

    public static String latFieldId(String locationFieldId) {
        return locationFieldId + "-lat";
    }

    public static String lngFieldId(String locationFieldId) {
        return locationFieldId + "-lng";
    }

    public LocationIndexer(FieldVisibilityManager fieldVisibilityManager, CustomField customField, DoubleConverter doubleConverter) {
        super(fieldVisibilityManager, (CustomField)Assertions.notNull((String)"field", (Object)customField));
        this.field = customField;
        this.doubleConverter = doubleConverter;
    }

    public void addDocumentFieldsSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NOT_ANALYZED);
    }

    public void addDocumentFieldsNotSearchable(Document doc, Issue issue) {
        this.addDocumentFields(doc, issue, Field.Index.NO);
    }

    private void addDocumentFields(Document doc, Issue issue, Field.Index index) {
        Object value = this.field.getValue(issue);
        if (value != null) {
            Location location = ((Location)value).normalize();
            doc.add((Fieldable)new Field(LocationIndexer.latFieldId(this.getDocumentFieldId()), this.doubleConverter.getStringForLucene(Double.valueOf(location.lat)), Field.Store.YES, index));
            doc.add((Fieldable)new Field(LocationIndexer.lngFieldId(this.getDocumentFieldId()), this.doubleConverter.getStringForLucene(Double.valueOf(location.lng)), Field.Store.YES, index));
        }
    }
}

