/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.customfields.GeoCalculator;

public class Location {
    public final double lat;
    public final double lng;

    public Location(String latLong) {
        String[] parts = latLong.split(",");
        this.lat = Double.parseDouble(parts[0]);
        this.lng = Double.parseDouble(parts[1]);
    }

    public Location(double lat, double lng) {
        this.lat = lat;
        this.lng = lng;
    }

    public String toString() {
        return String.format("%f,%f", this.lat, this.lng);
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public Location normalize() {
        return new Location(GeoCalculator.normalizeLat(this.lat), GeoCalculator.normalizeLng(this.lng));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Location location = (Location)o;
        if (Double.compare(location.lat, this.lat) != 0) {
            return false;
        }
        return Double.compare(location.lng, this.lng) == 0;
    }

    public int hashCode() {
        long temp = this.lat != 0.0 ? Double.doubleToLongBits(this.lat) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.lng != 0.0 ? Double.doubleToLongBits(this.lng) : 0L;
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }
}

