/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira.customfields;

import com.atlassian.core.util.XMLUtils;
import com.atlassian.jconnect.jira.IssueHelper;
import com.atlassian.jconnect.jira.customfields.Location;
import com.atlassian.jira.issue.Issue;
import java.util.regex.Matcher;

public class IssueLocation
extends Location {
    private final String key;
    private final String environment;
    private final String iconHtml;

    public IssueLocation(Location latLng, Issue issue) {
        super(latLng.lat, latLng.lng);
        this.key = issue.getKey();
        this.environment = this.escape(this.formatEnvironmentString(issue.getEnvironment()));
        this.iconHtml = issue.getIssueTypeObject().getIconUrlHtml();
    }

    public IssueLocation(Location latLng) {
        super(latLng.getLat(), latLng.getLng());
        this.key = null;
        this.environment = null;
        this.iconHtml = null;
    }

    private String escape(String in) {
        return XMLUtils.escape((String)in).replaceAll("\n", "<br/>");
    }

    @Override
    public String toString() {
        return this.key + ": " + super.toString();
    }

    public String getKey() {
        return this.key;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getIconHtml() {
        return this.iconHtml;
    }

    private String formatEnvironmentString(String environment) {
        Matcher matcher = IssueHelper.ENV_FIELD_PATTERN.matcher(environment);
        StringBuilder smallEnv = new StringBuilder();
        if (matcher.find() && matcher.groupCount() >= 3) {
            smallEnv.append(matcher.group(1)).append(" ").append(matcher.group(2)).append(" Version: ").append(matcher.group(3));
        }
        return smallEnv.toString().replaceAll("\n", " ");
    }
}

