/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jconnect.jira;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.jira.UserHelper;
import com.atlassian.jconnect.jira.customfields.BuiltInField;
import com.atlassian.jconnect.rest.entities.CommentEntity;
import com.atlassian.jconnect.rest.entities.IssueWithCommentsEntity;
import com.atlassian.jconnect.rest.entities.IssuesWithCommentsEntity;
import com.atlassian.jira.bc.issue.search.SearchService;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.atlassian.jira.issue.comments.CommentManager;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.search.SearchException;
import com.atlassian.jira.issue.search.SearchResults;
import com.atlassian.jira.jql.builder.JqlClauseBuilder;
import com.atlassian.jira.jql.builder.JqlQueryBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.usercompatibility.UserWithKey;
import com.atlassian.jira.web.bean.PagerFilter;
import com.atlassian.query.Query;
import com.atlassian.query.order.SortOrder;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueActivityService {
    private static final Logger log = LoggerFactory.getLogger(IssueActivityService.class);
    private final CommentManager commentManager;
    private final SearchService searchService;
    private final UserHelper userHelper;
    private final JMCProjectService jmcProjectService;
    private final CustomFieldManager customFieldManager;
    private static final Pattern PATTERN_UUID = Pattern.compile("([a-fA-F-\\d]{36})");
    private static final Pattern PATTERN_PROJECT_NAME = Pattern.compile("([a-fA-F-\\d].*)");

    public IssueActivityService(CommentManager commentManager, SearchService searchService, UserHelper userHelper, CustomFieldManager customFieldManager, JMCProjectService jmcProjectService) {
        this.commentManager = commentManager;
        this.searchService = searchService;
        this.userHelper = userHelper;
        this.customFieldManager = customFieldManager;
        this.jmcProjectService = jmcProjectService;
    }

    public IssuesWithCommentsEntity getIssuesWithCommentsIfUpdatesExists(Project project, String uuid, long sinceMillis) {
        IssuesWithCommentsEntity issuesWithComments = new IssuesWithCommentsEntity(new ArrayList<IssueWithCommentsEntity>(), System.currentTimeMillis(), !this.jmcProjectService.isCrashesEnabledFor(project));
        boolean issueHasUpdates = false;
        ApplicationUser user = this.userHelper.getJMCSystemUser();
        if (user != null) {
            if (!this.isValidUserParameter(uuid, PATTERN_UUID)) {
                return issuesWithComments;
            }
            CustomField uuidField = this.customFieldManager.getCustomFieldObjectByName(BuiltInField.UUID.fieldName());
            if (uuidField == null) {
                log.warn("Custom field: " + BuiltInField.UUID.fieldName() + " is missing from this instance. Ensure JIRA Mobile Connect is enabled.");
                return null;
            }
            JqlClauseBuilder userProjectClause = JqlQueryBuilder.newClauseBuilder().project().eq(project.getId()).and().customField(uuidField.getIdAsLong()).eq().string(uuid).and().reporter().eq().string(user.getName());
            JqlClauseBuilder dateClause = JqlQueryBuilder.newClauseBuilder().updated().gtEq(new Date(sinceMillis));
            Query query = JqlQueryBuilder.newBuilder().where().addClause(userProjectClause.buildClause()).and().addClause(dateClause.buildClause()).buildQuery();
            try {
                long resultCount = this.searchService.searchCount(user, query);
                if (resultCount > 0L) {
                    issueHasUpdates = this.retrieveIssuesWithComments(userProjectClause, sinceMillis, issuesWithComments, user);
                }
            }
            catch (SearchException e) {
                log.error("Error looking for updates via JQL: " + query.getWhereClause(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug(uuid + " issue count " + issuesWithComments.getIssues().size());
        }
        return issueHasUpdates ? issuesWithComments : new IssuesWithCommentsEntity(new LinkedList<IssueWithCommentsEntity>(), System.currentTimeMillis(), !this.jmcProjectService.isCrashesEnabledFor(project));
    }

    private boolean retrieveIssuesWithComments(JqlClauseBuilder builder, long sinceMillis, IssuesWithCommentsEntity issuesWithComments, ApplicationUser user) {
        Query query = JqlQueryBuilder.newBuilder((Query)builder.buildQuery()).orderBy().updatedDate(SortOrder.DESC).buildQuery();
        try {
            SearchResults searchResults = this.searchService.search(user, query, new PagerFilter(100));
            List issues = searchResults.getIssues();
            boolean hasAtLeastOneUpdate = false;
            for (Issue issue : issues) {
                ArrayList<CommentEntity> commentEntities = new ArrayList<CommentEntity>();
                boolean hasUpdates = false;
                List comments = this.commentManager.getCommentsForUser(issue, user);
                for (Comment comment : comments) {
                    boolean systemUser = this.commentManager.isUserCommentAuthor(user, comment);
                    if (comment.getUpdated().getTime() > sinceMillis && !systemUser) {
                        hasUpdates = true;
                        hasAtLeastOneUpdate = true;
                    }
                    UserWithKey userWithKey = UserCompatibilityHelper.convertUserObject(comment.getAuthorUser());
                    User commentUser = userWithKey.getUser();
                    CommentEntity commentEntity = new CommentEntity(userWithKey.getKey(), commentUser.getName(), commentUser.getDisplayName(), systemUser, comment.getBody(), comment.getUpdated(), issue.getKey());
                    commentEntities.add(commentEntity);
                }
                IssueWithCommentsEntity issueEntity = new IssueWithCommentsEntity(issue.getKey(), issue.getStatusObject().getName(), issue.getSummary(), issue.getDescription(), issue.getCreated(), issue.getUpdated(), commentEntities, hasUpdates);
                issuesWithComments.getIssues().add(issueEntity);
            }
            if (log.isDebugEnabled()) {
                log.debug(query.getWhereClause() + " issue count " + issuesWithComments.getIssues().size());
            }
            return hasAtLeastOneUpdate;
        }
        catch (SearchException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private boolean isValidUserParameter(String userEnteredString, Pattern matchPattern) {
        if (userEnteredString == null) {
            return false;
        }
        Matcher matcher = matchPattern.matcher(userEnteredString);
        if (!matcher.matches()) {
            log.warn(userEnteredString + " is invalid.");
            return false;
        }
        return true;
    }
}

