package com.atlassian.jconnect.util;

public class Either<L, R>
{
    private final L left;
    private final R right;
    
    public Either(L left, R right) {
        this.left = left;
        this.right = right;
    }
    
   /**
     * @param left the value to be stored, must not be null
     * @return a Left containing the supplied value
     */
   public static <L, R> Either<L, R> left(final L left)
   {
       return new Either<L, R>(left, null);
   }

   /**
     * @param right the value to be stored, must not be null
     * @return a Right containing the supplied value
     */
   public static <L, R> Either<L, R> right(final R right)
   {
       return new Either<L, R>(null, right);
   }

    public L getLeft() {
        return left;
    }

    public R getRight() {
        return right;
    }
}