package com.atlassian.jconnect.rest.entities;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.util.List;

@XmlRootElement(name = "issues")
@XmlAccessorType(XmlAccessType.FIELD)
public class IssuesWithCommentsEntity
{
    @XmlElement(name = "issuesWithComments")
    private List<IssueWithCommentsEntity> issues;

    /**
     * The system time since the last request made for this resource.
     * Clients need to store this value locally, and submit with the next request.
     * This determines which comment will be marked as 'read'.
     */
    @XmlElement(name = "sinceMillis")
    private long sinceMillis;

    @XmlElement(name = "crashReportingDisabledInJIRA")
    private boolean crashReportingDisabledInJIRA;


    private IssuesWithCommentsEntity()
    {
        // for jersey
    }

    public IssuesWithCommentsEntity(List<IssueWithCommentsEntity> oldIssues,
                                    long since,
                                    boolean crashReportingDisabled)
    {

        this.issues = oldIssues;
        this.sinceMillis = since;
        this.crashReportingDisabledInJIRA = crashReportingDisabled;
    }

    public List<IssueWithCommentsEntity> getIssues()
    {
        return issues;
    }

    public void setIssues(List<IssueWithCommentsEntity> issues)
    {
        this.issues = issues;
    }

    public long getSinceMillis()
    {
        return sinceMillis;
    }

    public boolean isCrashReportingDisabledInJIRA()
    {
        return crashReportingDisabledInJIRA;
    }
}
