package com.atlassian.jconnect.rest.entities;

import com.atlassian.jira.util.json.JSONArray;
import com.atlassian.jira.util.json.JSONException;
import com.atlassian.jira.util.json.JSONObject;
import org.apache.commons.lang.StringUtils;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@XmlRootElement(name = "issue")
@XmlAccessorType(XmlAccessType.FIELD)
public class IssueEntity
{
    // NOTE: ALL class fields are set reflectively in fromJSONObj() method

    private String uuid; // universally unique id: this is created once when the app first starts, then sent with each request
    private String udid; // device id: this is a publicly known id for identifying a device.
    private String devName;
    private String systemName;
    private String systemVersion;
    private String language;
    private String model;
    private String appVersion;
    private String appVersionShort;
    private String appName;
    private String appId;
    private String description;
    private String summary;
    private String type;         // the name of the issue type to use (NB: used for mapping exact issue type)
    private boolean isCrash;     // whether or not this issue was actually a crash. NB only used for enabling/disabling remote-kill
    private String[] components; // an array of issue components to set

    // TODO: why does this exist? Use JSON or GSON for json parsing and generation!
    public static IssueEntity fromJSONObj(JSONObject obj) throws JSONException
    {
        final IssueEntity issue = new IssueEntity();
        for (Field field : IssueEntity.class.getDeclaredFields()) {
            if (obj.has(field.getName())) {
                try {
                    if (field.getType().equals(boolean.class)) {
                        field.set(issue, obj.getBoolean(field.getName()));
                    } else if (field.getType().equals(String.class)) {
                        field.set(issue, obj.getString(field.getName()));
                    } else if (field.getType().equals(String[].class)) {
                        final JSONArray arr = obj.getJSONArray(field.getName());
                        final String[] strArr = new String[arr.length()];
                        for (int i = 0; i < arr.length(); i++) {
                              strArr[i] = arr.getString(i);
                        }
                        field.set(issue, strArr);
                    }
                } catch (IllegalAccessException e) {
                    throw new IllegalStateException("static factory method should be able to set private fields of instance of containing class!");
                }
            }
        }
        return issue;
    }

    public String getUuid() {
        return uuid;
    }

    public String getUdid()
    {
        return udid;
    }

    public String getDevName()
    {
        return devName;
    }

    public String getSystemName()
    {
        return systemName;
    }

    public String getSystemVersion()
    {
        return systemVersion;
    }

    public String getLanguage()
    {
        return language;
    }

    public String getModel()
    {
        return model;
    }

    public String getAppVersion()
    {
        return appVersion;
    }

    public String getAppVersionShort()
    {
        return appVersionShort;
    }

    public String getAppName()
    {
        return appName;
    }

    // TODO remove?
    public String getAppId()
    {
        return appId;
    }

    public String getDescription()
    {
        return isEmpty(description) ? "<no comment>" : description;
    }

    private static boolean isEmpty(String text) {
        return StringUtils.isBlank(text) || StringUtils.isWhitespace(text);
    }

    public String getSummary()
    {
        return isEmpty(summary) ? "<no title>" : summary;
    }
    
    public String getType() {
        return type;
    }

    public String[] getComponents() {
        return components;
    }

    public boolean isCrash() {
        return isCrash;
    }
}
