package com.atlassian.jconnect.rest.entities;


import javax.xml.bind.annotation.*;
import java.util.Date;

@XmlRootElement(name = "comment")
@XmlAccessorType(XmlAccessType.FIELD)
public class CommentEntity
{
    @XmlAttribute
    private String userKey;

    @XmlAttribute
    private String username;

    @XmlAttribute
    private String displayName;

    @XmlAttribute
    private String issueKey;

    @XmlAttribute(name = "systemUser")
    private boolean systemUser;

    @XmlElement(name = "text")
    private String comment;

    @XmlElement(name = "date")
    private Date date;


    private CommentEntity()
    {
        // for jersey
    }

    public CommentEntity(String userKey, String username, String displayName, boolean isSystemUser, String comment, Date date, String issueKey)
    {
        this.userKey = userKey;
        this.username = username;
        this.displayName = displayName;
        this.systemUser = isSystemUser;
        this.comment = comment;
        this.date = date;
        this.issueKey = issueKey;
    }

    @Override
    public String toString() {
        return "CommentEntity{" +
                "userkey=" + userKey + "'" +
                ", username='" + username + '\'' +
                ", displayName=" + displayName + "'" +
                ", systemUser=" + systemUser +
                ", comment='" + comment + '\'' +
                ", date=" + date + '\'' +
                ", issueKey=" + issueKey +
                '}';
    }
}
