package com.atlassian.jconnect.jira.tabpanel;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanel;
import com.atlassian.jira.plugin.projectpanel.ProjectTabPanelModuleDescriptor;
import com.atlassian.jira.project.browse.BrowseContext;
import com.google.common.collect.ImmutableList;

import java.util.*;

/**
 * JIRA Connect project tab panel.
 */
public class JiraConnectProjectTabPanel implements ProjectTabPanel {

    static final String I18N_PREFIX = "projecttabpanel";
    
    private final JMCProjectService projectService;

    private final List<AbstractFragment> fragments;
    private ProjectTabPanelModuleDescriptor descriptor;

    public JiraConnectProjectTabPanel(JMCProjectService projectService,
                                      GoogleMapsFragment googleMapsFragment,
                                      DeviceModelChartFragment deviceModelChartFragment,
                                      SystemVersionChartFragment systemVersionChartFragment,
                                      ApplicationVersionChartFragment applicationVersionChartFragment)
    {
        this.projectService = projectService;
        fragments = ImmutableList.of(googleMapsFragment,
                                     deviceModelChartFragment,
                                     systemVersionChartFragment,
                                     applicationVersionChartFragment);
    }

    public void init(ProjectTabPanelModuleDescriptor projectTabPanelModuleDescriptor)
    {
        this.descriptor = projectTabPanelModuleDescriptor;
    }

    public String getHtml(BrowseContext browseContext)
    {
        final Map<String, Object> context = new HashMap<String, Object>();
        final List<AbstractFragment> renderableFragments = new ArrayList<AbstractFragment>(fragments.size());
        for (Iterator<AbstractFragment> iterator = fragments.iterator(); iterator.hasNext(); )
        {
            final AbstractFragment fragment = iterator.next();
            if (fragment.showFragment(browseContext))
            {
                fragment.init(browseContext, descriptor);

                renderableFragments.add(fragment);
            }
        }
        context.put("fragments", renderableFragments);
        return descriptor.getHtml("view", context);
    }


    public boolean showPanel(BrowseContext context)
    {
        return projectService.isJiraConnectProject(context.getProject());
    }

}
