package com.atlassian.jconnect.jira.customfields;

import static com.atlassian.jconnect.jira.customfields.GeoCalculator.normalizeLat;
import static com.atlassian.jconnect.jira.customfields.GeoCalculator.normalizeLng;

/**
 * Simple bean encapsulating query for location: base location and radius to search within.
 *
 */
public class LocationQuery extends Location {

    public final long radius;

    public LocationQuery(double lat, double lng, long radius) {
        super(lat, lng);
        this.radius = radius;
    }

    public long getRadius() {
        return radius;
    }

    @Override
    public LocationQuery normalize() {
        return new LocationQuery(normalizeLat(lat), normalizeLng(lng), radius);
    }
}
