package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.customfields.impl.AbstractSingleFieldType;
import com.atlassian.jira.issue.customfields.impl.FieldValidationException;
import com.atlassian.jira.issue.customfields.manager.GenericConfigManager;
import com.atlassian.jira.issue.customfields.persistence.CustomFieldValuePersister;
import com.atlassian.jira.issue.customfields.persistence.PersistenceFieldType;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.layout.field.FieldLayoutItem;

import java.util.Map;

/**
 *
 */
public class LocationCFType extends AbstractSingleFieldType<Location> {

    protected LocationCFType(CustomFieldValuePersister customFieldValuePersister, GenericConfigManager genericConfigManager) {
        super(customFieldValuePersister, genericConfigManager);
    }

    @Override
    public void updateValue(final CustomField customField, final Issue issue, final Location value)
    {
        // Read-only CF, do nothing.
    }

    @Override
    protected PersistenceFieldType getDatabaseType() {
        return PersistenceFieldType.TYPE_LIMITED_TEXT;
    }

    @Override
    protected Object getDbValueFromObject(Location location) {
        return location != null ? location.toString() : null;
    }

    @Override
    protected Location getObjectFromDbValue(Object databaseValue) throws FieldValidationException {
        String locStr = (String) databaseValue;
        return new Location(locStr);
    }

    public String getStringFromSingularObject(Location location) {
        assertObjectImplementsType(Location.class, location);
        return location.toString();
    }

    public Location getSingularObjectFromString(String string) throws FieldValidationException {
        return new Location(string);
    }

    @Override
    public Map<String, Object> getVelocityParameters(Issue issue, CustomField field, FieldLayoutItem fieldLayoutItem) {
        final Map<String, Object> context = super.getVelocityParameters(issue, field, fieldLayoutItem);
        final Location value = issue != null ? (Location) issue.getCustomFieldValue(field) : null;
        if (value != null) {
            final IssueLocation issueLocation = (issue == null) ?
                    new IssueLocation(value) : new IssueLocation(value, issue);
            context.put("location", issueLocation);
        }
        return context;
    }

}
