package com.atlassian.jconnect.jira.customfields;

import com.atlassian.core.util.XMLUtils;
import com.atlassian.jconnect.jira.IssueHelper;
import com.atlassian.jira.issue.Issue;

import java.util.regex.Matcher;

/**
 * Issue with location.
 *
 * @since v4.4
 */
public class IssueLocation extends Location
{

    private final String key;
    private final String environment;
    private final String iconHtml;

    public IssueLocation(Location latLng, Issue issue)
    {
        super(latLng.lat, latLng.lng);
        this.key = issue.getKey();
        this.environment = escape(formatEnvironmentString(issue.getEnvironment()));
        this.iconHtml = issue.getIssueTypeObject().getIconUrlHtml();
    }

    public IssueLocation(Location latLng)
    {
        super(latLng.getLat(), latLng.getLng());
        this.key = null;
        this.environment = null;
        this.iconHtml = null;
    }

    private String escape(String in)
    {
        return XMLUtils.escape(in).replaceAll("\n", "<br/>");
    }

    @Override
    public String toString()
    {
        return key + ": " + super.toString();
    }

    public String getKey()
    {
        return key;
    }

    public String getEnvironment()
    {
        return environment;
    }

    public String getIconHtml()
    {
        return iconHtml;
    }

    private String formatEnvironmentString(String environment) {
        // format the environment String a little
        // TODO: find a better way to store this device info?
        // TODO: Custom fields would be good, when we can auto-add them to a project.
        final Matcher matcher = IssueHelper.ENV_FIELD_PATTERN.matcher(environment);
        final StringBuilder smallEnv = new StringBuilder();
        if (matcher.find() && matcher.groupCount() >= 3) {
            smallEnv.append(matcher.group(1)).append(" ").append(matcher.group(2)).append(" Version: ").append(matcher.group(3));
        }
        
        return smallEnv.toString().replaceAll("\n", " ");
    }
    

}
