package com.atlassian.jconnect.jira.customfields;

import com.atlassian.jconnect.jira.PluginInfo;

import static com.atlassian.jira.util.lang.JiraStringUtils.asString;

/**
 * Enumeration of built-in custom fields in used by JIRA Connect.
 *
 */
public enum BuiltInField {

    UUID("uuid",
            PluginInfo.JMC_PLUGIN_ID + ":uuid",
            PluginInfo.JMC_PLUGIN_ID + ":uuid-searcher",
            false),
    LOCATION("Location",
            PluginInfo.JMC_PLUGIN_ID + ":location",
            PluginInfo.JMC_PLUGIN_ID + ":location-searcher",
            true);

    private final String fieldName;
    private final String fieldTypeKey;
    private final String searcherKey;
    private final boolean visible;

    BuiltInField(String fieldName, String fieldTypeKey, String searcherKey, boolean visible) {
        this.fieldName = fieldName;
        this.fieldTypeKey = fieldTypeKey;
        this.searcherKey = searcherKey;
        this.visible = visible;
    }

    public String fieldName() {
        return fieldName;
    }

    public String fieldTypeKey() {
        return fieldTypeKey;
    }

    public String searcherKey() {
        return searcherKey;
    }

    public boolean isVisible()
    {
        return visible;
    }

    public String fullDescription() {
        return asString(toString(), "[", fieldName, ",", fieldTypeKey, ",", searcherKey, "]");
    }
}
