package com.atlassian.jconnect.jira.admin;

import com.atlassian.jconnect.jira.JMCProjectService;
import com.atlassian.jconnect.rest.entities.ProjectStatusEntity;
import com.atlassian.jira.plugin.projectoperation.AbstractPluggableProjectOperation;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;

import java.util.HashMap;
import java.util.Map;

/**
 * A project setting appears on the per-project settings page in JIRA.
 * This is at plugins/servlet/project-config/PROJECT-KEY/summary
 * The Plugin Settings are down the bottom left, in the Settings section.
 */
public class JMCProjectSettings extends AbstractPluggableProjectOperation {

    private final JMCProjectService projectService;

    public JMCProjectSettings(JMCProjectService projectService) {
        this.projectService = projectService;
    }

    public String getHtml(Project project, ApplicationUser user) {

        final Map<String, Object> startingParams = new HashMap<String, Object>();
        final boolean enabled = projectService.isJiraConnectProject(project);
        final String apiKey = enabled ? projectService.lookupApiKeyFor(project) : "";
        final boolean apiKeyActive = projectService.isApiKeyEnabledFor(project);
        final boolean crashesEnabled = projectService.isCrashesEnabledFor(project);

        startingParams.put("projectStatus",
                new ProjectStatusEntity(project.getId(),
                                                    project.getKey(),
                                                    enabled,
                                                    apiKey,
                                                    false,     // re-index never needed on view. only one toggle
                                                    apiKeyActive,
                                                    crashesEnabled));
        final String html = this.descriptor.getHtml("view", startingParams);
        return html;
    }

    public boolean showOperation(Project project, ApplicationUser user) {
        return true;
    }

}
