package com.atlassian.jconnect.jira;

import com.atlassian.jira.bc.user.UserService;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.usercompatibility.UserCompatibilityHelper;
import com.atlassian.jira.usercompatibility.UserWithKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.UUID;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * Performs some common user operations.
 */
public class UserHelper
{
    private static final Logger log = LoggerFactory.getLogger(UserHelper.class);
    private static final String SYSTEM_USERNAME = "jiraconnectuser";

    private final UserService userService;
    private final UserManager userManager;

    public UserHelper(UserService userService, UserManager userManager)
    {
        this.userService = userService;
        this.userManager = userManager;
    }
    
    public ApplicationUser getJMCSystemUser()
    {
        final String username = SYSTEM_USERNAME;
        log.debug("Retrieving user " + username);
        return userManager.getUser(username);
    }

    public UserWithKey getUser(String username)
    {
        return UserCompatibilityHelper.convertUserObject(userManager.getUserObject(username));
    }

    public ApplicationUser getApplicationUser(String username)
    {
        return userManager.getUserByKey(username);
    }

    public ApplicationUser getOrCreateJMCSystemUser()
    {
        // try to resolve user
        ApplicationUser user = getJMCSystemUser();

        // create user if they don't already exist
        if (user == null)
        {
            // todo these could be reconsidered..
            // make up some stub values for the required fields
            final String udid = SYSTEM_USERNAME;

            final String password = UUID.randomUUID().toString(); // TODO: possible to create a user w/o login permission ?
            final String email = udid + "@connect.jira.com";
            final String fullName = udid;

            // add user (as if signing up)
            final UserService.CreateUserValidationResult validationResult =
                    userService.validateCreateUserForSignup(null, asUsername(udid), password, password, email, fullName);
            try
            {
                userService.createUserNoNotification(validationResult);
                log.debug("Created user: " + udid);
            }
            catch (Exception e)
            {
                log.error("Failed to create user", e);
                return null;
            }

            checkNotNull(user, "user");
        }
        return user;
    }

    private String asUsername(final String udid)
    {
        return udid.toLowerCase();
    }
}
