package com.atlassian.jconnect.jira;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.user.ApplicationUser;

/**
 * Performs JIRA Connect specific operations on JIRA projects.
 *
 */
public interface JMCProjectService
{

    /**
     * @param project the project to toggle JMC on/off
     * @return true if the project is JIRA Mobile Connect 'enabled'
     */
    boolean toggleForJiraConnect(Project project);

    public boolean reindexRequiredFor(Project project, ApplicationUser user);

    public String lookupApiKeyFor(Project project);

    public String generateOrRetrieveAPIKeyFor(Project project);

    /**
     * Check whether given project is JIRA Connect enabled.
     *
     * @param project project to check
     * @return <code>true</code>, if <tt>project</tt> is JIRA Connect enabled
     */
    boolean isJiraConnectProject(Project project);

    long countJMCIssues(ApplicationUser user);

    String generateApiKeyFor(Project project);

    boolean toggleApiKeyFor(Project project, boolean enable);

    boolean toggleCrashesFor(Project project, boolean enable);

    boolean isApiKeyEnabledFor(Project project);

    boolean isCrashesEnabledFor(Project project);
}
