/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.JiraCreateIssueForm;
import com.atlassian.webdriver.integration.jira.element.JiraDialog;
import org.openqa.selenium.By;

public class JiraCreateIssueDialog
extends JiraDialog {
    private static final String CONTAINER_ID = "create-jira-issue-dialog";

    public JiraCreateIssueDialog() {
        super(By.id((String)CONTAINER_ID));
    }

    @Override
    public TimedCondition isOpen() {
        return this.root.find(By.className((String)"jira-create-form"), TimeoutType.DIALOG_LOAD).timed().isVisible();
    }

    public TimedCondition hasProjectSelector() {
        return this.root.find(By.className((String)"project-select"), TimeoutType.AJAX_ACTION).timed().isVisible();
    }

    private PageElement getCreateButton() {
        return this.root.find(By.className((String)"confirm-button"));
    }

    public void createIssue(boolean expectSuccess) {
        PageElement createButton = this.getCreateButton();
        Poller.waitUntilTrue((TimedQuery)createButton.timed().isEnabled());
        createButton.click();
        if (expectSuccess) {
            Poller.waitUntilFalse((TimedQuery)this.isOpen());
        }
    }

    public JiraCreateIssueForm getForm() {
        return (JiraCreateIssueForm)this.pageBinder.bind(JiraCreateIssueForm.class, new Object[]{this.root.find(By.className((String)"jira-create-form")), this});
    }

    @Override
    protected By getCancelButtonLocator() {
        return By.className((String)"cancel-button");
    }
}

