/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element.internal;

import com.atlassian.pageobjects.elements.ElementBy;
import com.atlassian.pageobjects.elements.PageElement;
import com.atlassian.pageobjects.elements.PageElementFinder;
import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.Queries;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.Timeouts;
import com.google.common.base.Supplier;
import javax.inject.Inject;
import org.openqa.selenium.JavascriptExecutor;

public class WebLoginPage {
    public static final String USERNAME_FIELD_NAME = "os_username";
    @Inject
    protected JavascriptExecutor javascriptExecutor;
    @Inject
    protected Timeouts timeouts;
    @Inject
    private PageElementFinder elementFinder;
    @ElementBy(name="os_username")
    private PageElement usernameField;
    @ElementBy(name="os_password")
    private PageElement passwordField;
    @ElementBy(name="login")
    private PageElement submitButton;

    public TimedCondition isShowing() {
        return this.usernameField.timed().isPresent();
    }

    public void handleWebLoginIfRequired(String username, String password) {
        if (this.usernameField.isPresent()) {
            this.usernameField.type(new CharSequence[]{username});
            this.passwordField.type(new CharSequence[]{password});
            this.waitForPagePop(new Runnable(){

                @Override
                public void run() {
                    WebLoginPage.this.submitButton.click();
                }
            });
        }
        if (this.usernameField.isPresent()) {
            throw new IllegalStateException("should already be logged in by now");
        }
    }

    private void waitForPagePop(Runnable runnable) {
        this.javascriptExecutor.executeScript("window.pagePopExpected = true;", new Object[0]);
        runnable.run();
        Poller.waitUntilTrue((TimedQuery)Queries.forSupplier((Timeouts)this.timeouts, (Supplier)new Supplier<Boolean>(){

            public Boolean get() {
                return (Boolean)WebLoginPage.this.javascriptExecutor.executeScript("return window && window.pagePopExpected !== true;", new Object[0]);
            }
        }));
    }
}

