/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webdriver.integration.jira.element;

import com.atlassian.pageobjects.elements.query.Poller;
import com.atlassian.pageobjects.elements.query.TimedCondition;
import com.atlassian.pageobjects.elements.query.TimedQuery;
import com.atlassian.pageobjects.elements.timeout.TimeoutType;
import com.atlassian.webdriver.integration.jira.element.JiraDialog;
import com.atlassian.webdriver.integration.jira.element.JiraIssuePanel;
import com.atlassian.webdriver.integration.jira.element.JiraTransitionForm;
import org.openqa.selenium.By;

public class JiraIssuesDialog
extends JiraDialog {
    public JiraIssuesDialog(By locator) {
        super(locator);
    }

    public TimedCondition isShowing(String issueKey) {
        return this.getIssuePanel().isShowing(issueKey);
    }

    public void waitUntilDetailsShown() {
        Poller.waitUntilTrue((TimedQuery)this.root.find(By.className((String)"jira-issue-detailed"), TimeoutType.SLOW_PAGE_LOAD).timed().isVisible());
    }

    public JiraIssuePanel getIssuePanel() {
        this.waitUntilDetailsShown();
        return (JiraIssuePanel)this.pageBinder.bind(JiraIssuePanel.class, new Object[]{this.root.find(By.className((String)"jira-issue-detailed")), this});
    }

    public JiraTransitionForm getTransitionForm() {
        return (JiraTransitionForm)this.pageBinder.bind(JiraTransitionForm.class, new Object[]{this.root.find(By.className((String)"jira-transition-form")), this});
    }

    public JiraIssuesDialog goToNextIssue() {
        String key = this.getIssuePanel().getIssueKey();
        this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{"j"});
        Poller.waitUntilFalse((TimedQuery)this.isShowing(key));
        this.waitUntilDetailsShown();
        return this;
    }

    public JiraIssuesDialog goToPreviousIssue() {
        String key = this.getIssuePanel().getIssueKey();
        this.driver.findElement(By.tagName((String)"body")).sendKeys(new CharSequence[]{"k"});
        Poller.waitUntilFalse((TimedQuery)this.isShowing(key));
        this.waitUntilDetailsShown();
        return this;
    }

    @Override
    protected By getCancelButtonLocator() {
        return By.className((String)"button-panel-cancel-link");
    }
}

