/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.AtlassianScimExtension;
import com.atlassian.idp.model.ImmutableScimGroup;
import com.atlassian.idp.model.ScimGroupMember;
import com.atlassian.idp.model.ScimMeta;
import com.atlassian.idp.model.annotation.ScimValue;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import org.immutables.value.Value;

@JsonSerialize(as=ImmutableScimGroup.class)
@JsonDeserialize(as=ImmutableScimGroup.class)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@ScimValue
@Value.Immutable
public abstract class ScimGroup {
    public static final String SCHEMA = "urn:ietf:params:scim:schemas:core:2.0:Group";
    public static final String MEMBERS = "members";

    @Nullable
    @Value.Default
    @Value.Parameter
    public Set<String> getSchemas() {
        return ImmutableSet.of((Object)SCHEMA, (Object)"urn:scim:schemas:extension:atlassian:1.0");
    }

    @Nullable
    @Value.Parameter
    public abstract String getId();

    @Nullable
    @Value.Parameter
    public abstract String getDisplayName();

    @Nullable
    @Value.Parameter
    public abstract List<ScimGroupMember> getMembers();

    @Nullable
    @Value.Parameter
    public abstract ScimMeta getMeta();

    @Nullable
    @JsonProperty(value="urn:scim:schemas:extension:atlassian:1.0")
    @Value.Parameter
    public abstract AtlassianScimExtension getAtlassianScimExtension();

    @Value.Check
    protected void checkSchemas() {
        Optional.ofNullable(this.getSchemas()).ifPresent(schemas -> Preconditions.checkArgument((boolean)schemas.contains(SCHEMA), (Object)("Invalid schema ('" + Arrays.toString(schemas.toArray()) + "') provided. Required value is " + SCHEMA)));
    }
}

