/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimUser;
import com.atlassian.idp.model.ScimUserListResponse;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimUserListResponse
extends ScimUserListResponse {
    @Nullable
    private final Set<String> schemas;
    @Nullable
    private final Integer totalResults;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final Integer itemsPerPage;
    @Nullable
    private final List<ScimUser> resources;

    private ImmutableScimUserListResponse(Builder builder) {
        this.totalResults = builder.totalResults;
        this.startIndex = builder.startIndex;
        this.itemsPerPage = builder.itemsPerPage;
        List<Object> list = this.resources = builder.resources == null ? null : ImmutableScimUserListResponse.createUnmodifiableList(true, builder.resources);
        this.schemas = builder.schemasIsSet() ? (builder.schemas == null ? null : ImmutableScimUserListResponse.createUnmodifiableSet(builder.schemas)) : (super.getSchemas() == null ? null : ImmutableScimUserListResponse.createUnmodifiableSet(ImmutableScimUserListResponse.createSafeList(super.getSchemas(), true, false)));
    }

    private ImmutableScimUserListResponse(@Nullable Set<String> schemas, @Nullable Integer totalResults, @Nullable Integer startIndex, @Nullable Integer itemsPerPage, @Nullable List<ScimUser> resources) {
        this.schemas = schemas;
        this.totalResults = totalResults;
        this.startIndex = startIndex;
        this.itemsPerPage = itemsPerPage;
        this.resources = resources;
    }

    @Override
    @JsonProperty
    @Nullable
    public Set<String> getSchemas() {
        return this.schemas;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getItemsPerPage() {
        return this.itemsPerPage;
    }

    @Override
    @JsonProperty(value="Resources")
    @Nullable
    public List<ScimUser> getResources() {
        return this.resources;
    }

    public final ImmutableScimUserListResponse withSchemas(String ... elements) {
        if (elements == null) {
            return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(null, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
        }
        Set<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUserListResponse.createUnmodifiableSet(ImmutableScimUserListResponse.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(newValue, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimUserListResponse withSchemas(@Nullable Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        Set<String> newValue = elements == null ? null : ImmutableScimUserListResponse.createUnmodifiableSet(ImmutableScimUserListResponse.createSafeList(elements, true, false));
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(newValue, this.totalResults, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimUserListResponse withTotalResults(@Nullable Integer value) {
        if (Objects.equals(this.totalResults, value)) {
            return this;
        }
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, value, this.startIndex, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimUserListResponse withStartIndex(@Nullable Integer value) {
        if (Objects.equals(this.startIndex, value)) {
            return this;
        }
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, this.totalResults, value, this.itemsPerPage, this.resources));
    }

    public final ImmutableScimUserListResponse withItemsPerPage(@Nullable Integer value) {
        if (Objects.equals(this.itemsPerPage, value)) {
            return this;
        }
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, this.totalResults, this.startIndex, value, this.resources));
    }

    public final ImmutableScimUserListResponse withResources(ScimUser ... elements) {
        if (elements == null) {
            return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, null));
        }
        List<ScimUser> newValue = Arrays.asList(elements) == null ? null : ImmutableScimUserListResponse.createUnmodifiableList(false, ImmutableScimUserListResponse.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, newValue));
    }

    public final ImmutableScimUserListResponse withResources(@Nullable Iterable<? extends ScimUser> elements) {
        if (this.resources == elements) {
            return this;
        }
        List<ScimUser> newValue = elements == null ? null : ImmutableScimUserListResponse.createUnmodifiableList(false, ImmutableScimUserListResponse.createSafeList(elements, true, false));
        return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this.schemas, this.totalResults, this.startIndex, this.itemsPerPage, newValue));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimUserListResponse && this.equalTo((ImmutableScimUserListResponse)another);
    }

    private boolean equalTo(ImmutableScimUserListResponse another) {
        return Objects.equals(this.schemas, another.schemas) && Objects.equals(this.totalResults, another.totalResults) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.itemsPerPage, another.itemsPerPage) && Objects.equals(this.resources, another.resources);
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + Objects.hashCode(this.schemas);
        h = h * 17 + Objects.hashCode(this.totalResults);
        h = h * 17 + Objects.hashCode(this.startIndex);
        h = h * 17 + Objects.hashCode(this.itemsPerPage);
        h = h * 17 + Objects.hashCode(this.resources);
        return h;
    }

    public String toString() {
        return "ScimUserListResponse{schemas=" + this.schemas + ", totalResults=" + this.totalResults + ", startIndex=" + this.startIndex + ", itemsPerPage=" + this.itemsPerPage + ", resources=" + this.resources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimUserListResponse fromJson(Json json) {
        Builder builder = ImmutableScimUserListResponse.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.totalResults != null) {
            builder.withTotalResults(json.totalResults);
        }
        if (json.startIndex != null) {
            builder.withStartIndex(json.startIndex);
        }
        if (json.itemsPerPage != null) {
            builder.withItemsPerPage(json.itemsPerPage);
        }
        if (json.resources != null) {
            builder.addAllResources(json.resources);
        }
        return builder.build();
    }

    private static ImmutableScimUserListResponse validate(ImmutableScimUserListResponse instance) {
        instance.checkSchemas();
        return instance;
    }

    public static ImmutableScimUserListResponse copyOf(ScimUserListResponse instance) {
        if (instance instanceof ImmutableScimUserListResponse) {
            return (ImmutableScimUserListResponse)instance;
        }
        return ImmutableScimUserListResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <T> Set<T> createUnmodifiableSet(List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(list.get(0));
            }
        }
        LinkedHashSet<T> set = new LinkedHashSet<T>(list.size());
        set.addAll(list);
        return Collections.unmodifiableSet(set);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = null;
        @Nullable
        private Integer totalResults;
        @Nullable
        private Integer startIndex;
        @Nullable
        private Integer itemsPerPage;
        private List<ScimUser> resources = null;

        private Builder() {
        }

        public final Builder from(ScimUserListResponse instance) {
            List resourcesValue;
            Integer itemsPerPageValue;
            Integer startIndexValue;
            Integer totalResultsValue;
            Objects.requireNonNull(instance, "instance");
            Set<String> schemasValue = instance.getSchemas();
            if (schemasValue != null) {
                this.addAllSchemas(schemasValue);
            }
            if ((totalResultsValue = instance.getTotalResults()) != null) {
                this.withTotalResults(totalResultsValue);
            }
            if ((startIndexValue = instance.getStartIndex()) != null) {
                this.withStartIndex(startIndexValue);
            }
            if ((itemsPerPageValue = instance.getItemsPerPage()) != null) {
                this.withItemsPerPage(itemsPerPageValue);
            }
            if ((resourcesValue = instance.getResources()) != null) {
                this.addAllResources(resourcesValue);
            }
            return this;
        }

        public final Builder addSchemas(String element) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.schemas = null;
                this.optBits |= 1L;
                return this;
            }
            this.schemas = new ArrayList<String>();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            Objects.requireNonNull(elements, "schemas element");
            if (this.schemas == null) {
                this.schemas = new ArrayList<String>();
            }
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withTotalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
            return this;
        }

        public final Builder withStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Builder withItemsPerPage(@Nullable Integer itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
            return this;
        }

        public final Builder addResources(ScimUser element) {
            if (this.resources == null) {
                this.resources = new ArrayList<ScimUser>();
            }
            this.resources.add(Objects.requireNonNull(element, "resources element"));
            return this;
        }

        public final Builder addResources(ScimUser ... elements) {
            if (this.resources == null) {
                this.resources = new ArrayList<ScimUser>();
            }
            for (ScimUser element : elements) {
                this.resources.add(Objects.requireNonNull(element, "resources element"));
            }
            return this;
        }

        public final Builder withResources(@Nullable Iterable<? extends ScimUser> elements) {
            if (elements == null) {
                this.resources = null;
                return this;
            }
            this.resources = new ArrayList<ScimUser>();
            return this.addAllResources(elements);
        }

        public final Builder addAllResources(Iterable<? extends ScimUser> elements) {
            Objects.requireNonNull(elements, "resources element");
            if (this.resources == null) {
                this.resources = new ArrayList<ScimUser>();
            }
            for (ScimUser scimUser : elements) {
                this.resources.add(Objects.requireNonNull(scimUser, "resources element"));
            }
            return this;
        }

        public ImmutableScimUserListResponse build() {
            return ImmutableScimUserListResponse.validate(new ImmutableScimUserListResponse(this));
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimUserListResponse {
        Set<String> schemas = null;
        boolean schemasIsSet;
        @Nullable
        Integer totalResults;
        @Nullable
        Integer startIndex;
        @Nullable
        Integer itemsPerPage;
        List<ScimUser> resources = null;

        Json() {
        }

        @JsonProperty
        public void setSchemas(@Nullable Set<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty
        public void setTotalResults(@Nullable Integer totalResults) {
            this.totalResults = totalResults;
        }

        @JsonProperty
        public void setStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
        }

        @JsonProperty
        public void setItemsPerPage(@Nullable Integer itemsPerPage) {
            this.itemsPerPage = itemsPerPage;
        }

        @JsonProperty(value="Resources")
        public void setResources(@Nullable List<ScimUser> resources) {
            this.resources = resources;
        }

        @Override
        public Set<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getTotalResults() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getItemsPerPage() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<ScimUser> getResources() {
            throw new UnsupportedOperationException();
        }
    }
}

