/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.idp.model;

import com.atlassian.idp.model.ScimSearchRequest;
import com.atlassian.idp.model.ScimSortOrder;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@Immutable
public final class ImmutableScimSearchRequest
extends ScimSearchRequest {
    private final List<String> schemas;
    @Nullable
    private final List<String> attributes;
    @Nullable
    private final List<String> excludedAttributes;
    @Nullable
    private final String filter;
    @Nullable
    private final String sortBy;
    @Nullable
    private final ScimSortOrder sortOrder;
    @Nullable
    private final Integer startIndex;
    @Nullable
    private final Integer count;
    private final boolean shouldHideResources;
    private static final int STAGE_INITIALIZING = -1;
    private static final int STAGE_UNINITIALIZED = 0;
    private static final int STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableScimSearchRequest(Builder builder) {
        this.attributes = builder.attributes == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(true, builder.attributes);
        this.excludedAttributes = builder.excludedAttributes == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(true, builder.excludedAttributes);
        this.filter = builder.filter;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.startIndex = builder.startIndex;
        this.count = builder.count;
        if (builder.schemasIsSet()) {
            this.initShim.withSchemas(ImmutableScimSearchRequest.createUnmodifiableList(true, builder.schemas));
        }
        this.schemas = this.initShim.getSchemas();
        this.shouldHideResources = this.initShim.shouldHideResources();
        this.initShim = null;
    }

    private ImmutableScimSearchRequest(List<String> schemas, @Nullable List<String> attributes, @Nullable List<String> excludedAttributes, @Nullable String filter, @Nullable String sortBy, @Nullable ScimSortOrder sortOrder, @Nullable Integer startIndex, @Nullable Integer count) {
        this.schemas = schemas;
        this.attributes = attributes;
        this.excludedAttributes = excludedAttributes;
        this.filter = filter;
        this.sortBy = sortBy;
        this.sortOrder = sortOrder;
        this.startIndex = startIndex;
        this.count = count;
        this.initShim.withSchemas(this.schemas);
        this.shouldHideResources = this.initShim.shouldHideResources();
        this.initShim = null;
    }

    @Override
    @JsonProperty
    public List<String> getSchemas() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getSchemas() : this.schemas;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @JsonProperty
    @Nullable
    public List<String> getExcludedAttributes() {
        return this.excludedAttributes;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getFilter() {
        return this.filter;
    }

    @Override
    @JsonProperty
    @Nullable
    public String getSortBy() {
        return this.sortBy;
    }

    @Override
    @JsonProperty
    @Nullable
    public ScimSortOrder getSortOrder() {
        return this.sortOrder;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getStartIndex() {
        return this.startIndex;
    }

    @Override
    @JsonProperty
    @Nullable
    public Integer getCount() {
        return this.count;
    }

    @Override
    @JsonProperty
    public boolean shouldHideResources() {
        InitShim shim = this.initShim;
        return shim != null ? shim.shouldHideResources() : this.shouldHideResources;
    }

    public final ImmutableScimSearchRequest withSchemas(String ... elements) {
        List<String> newValue = ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(newValue, this.attributes, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withSchemas(Iterable<String> elements) {
        if (this.schemas == elements) {
            return this;
        }
        List<String> newValue = ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(elements, true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(newValue, this.attributes, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withAttributes(String ... elements) {
        if (elements == null) {
            return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, null, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, newValue, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withAttributes(@Nullable Iterable<String> elements) {
        if (this.attributes == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(elements, true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, newValue, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withExcludedAttributes(String ... elements) {
        if (elements == null) {
            return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, null, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
        }
        List<String> newValue = Arrays.asList(elements) == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, newValue, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withExcludedAttributes(@Nullable Iterable<String> elements) {
        if (this.excludedAttributes == elements) {
            return this;
        }
        List<String> newValue = elements == null ? null : ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(elements, true, false));
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, newValue, this.filter, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withFilter(@Nullable String value) {
        if (Objects.equals(this.filter, value)) {
            return this;
        }
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, this.excludedAttributes, value, this.sortBy, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withSortBy(@Nullable String value) {
        if (Objects.equals(this.sortBy, value)) {
            return this;
        }
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, this.excludedAttributes, this.filter, value, this.sortOrder, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withSortOrder(@Nullable ScimSortOrder value) {
        if (this.sortOrder == value) {
            return this;
        }
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, this.excludedAttributes, this.filter, this.sortBy, value, this.startIndex, this.count));
    }

    public final ImmutableScimSearchRequest withStartIndex(@Nullable Integer value) {
        if (Objects.equals(this.startIndex, value)) {
            return this;
        }
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, value, this.count));
    }

    public final ImmutableScimSearchRequest withCount(@Nullable Integer value) {
        if (Objects.equals(this.count, value)) {
            return this;
        }
        return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this.schemas, this.attributes, this.excludedAttributes, this.filter, this.sortBy, this.sortOrder, this.startIndex, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableScimSearchRequest && this.equalTo((ImmutableScimSearchRequest)another);
    }

    private boolean equalTo(ImmutableScimSearchRequest another) {
        return this.schemas.equals(another.schemas) && Objects.equals(this.attributes, another.attributes) && Objects.equals(this.excludedAttributes, another.excludedAttributes) && Objects.equals(this.filter, another.filter) && Objects.equals(this.sortBy, another.sortBy) && Objects.equals((Object)this.sortOrder, (Object)another.sortOrder) && Objects.equals(this.startIndex, another.startIndex) && Objects.equals(this.count, another.count) && this.shouldHideResources == another.shouldHideResources;
    }

    public int hashCode() {
        int h = 31;
        h = h * 17 + this.schemas.hashCode();
        h = h * 17 + Objects.hashCode(this.attributes);
        h = h * 17 + Objects.hashCode(this.excludedAttributes);
        h = h * 17 + Objects.hashCode(this.filter);
        h = h * 17 + Objects.hashCode(this.sortBy);
        h = h * 17 + Objects.hashCode((Object)this.sortOrder);
        h = h * 17 + Objects.hashCode(this.startIndex);
        h = h * 17 + Objects.hashCode(this.count);
        h = h * 17 + Boolean.hashCode(this.shouldHideResources);
        return h;
    }

    public String toString() {
        return "ScimSearchRequest{schemas=" + this.schemas + ", attributes=" + this.attributes + ", excludedAttributes=" + this.excludedAttributes + ", filter=" + this.filter + ", sortBy=" + this.sortBy + ", sortOrder=" + (Object)((Object)this.sortOrder) + ", startIndex=" + this.startIndex + ", count=" + this.count + ", shouldHideResources=" + this.shouldHideResources + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableScimSearchRequest fromJson(Json json) {
        Builder builder = ImmutableScimSearchRequest.builder();
        if (json.schemasIsSet) {
            builder.withSchemas(json.schemas);
        }
        if (json.attributes != null) {
            builder.addAllAttributes(json.attributes);
        }
        if (json.excludedAttributes != null) {
            builder.addAllExcludedAttributes(json.excludedAttributes);
        }
        if (json.filter != null) {
            builder.withFilter(json.filter);
        }
        if (json.sortBy != null) {
            builder.withSortBy(json.sortBy);
        }
        if (json.sortOrder != null) {
            builder.withSortOrder(json.sortOrder);
        }
        if (json.startIndex != null) {
            builder.withStartIndex(json.startIndex);
        }
        if (json.count != null) {
            builder.withCount(json.count);
        }
        return builder.build();
    }

    private static ImmutableScimSearchRequest validate(ImmutableScimSearchRequest instance) {
        instance = (ImmutableScimSearchRequest)instance.normalizeCount();
        instance = (ImmutableScimSearchRequest)instance.normalizeStartIndex();
        return instance;
    }

    public static ImmutableScimSearchRequest copyOf(ScimSearchRequest instance) {
        if (instance instanceof ImmutableScimSearchRequest) {
            return (ImmutableScimSearchRequest)instance;
        }
        return ImmutableScimSearchRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_SCHEMAS = 1L;
        private long optBits;
        private List<String> schemas = new ArrayList<String>();
        private List<String> attributes = null;
        private List<String> excludedAttributes = null;
        @Nullable
        private String filter;
        @Nullable
        private String sortBy;
        @Nullable
        private ScimSortOrder sortOrder;
        @Nullable
        private Integer startIndex;
        @Nullable
        private Integer count;

        private Builder() {
        }

        public final Builder from(ScimSearchRequest instance) {
            Integer countValue;
            Integer startIndexValue;
            ScimSortOrder sortOrderValue;
            String sortByValue;
            String filterValue;
            List<String> excludedAttributesValue;
            Objects.requireNonNull(instance, "instance");
            this.addAllSchemas(instance.getSchemas());
            List<String> attributesValue = instance.getAttributes();
            if (attributesValue != null) {
                this.addAllAttributes(attributesValue);
            }
            if ((excludedAttributesValue = instance.getExcludedAttributes()) != null) {
                this.addAllExcludedAttributes(excludedAttributesValue);
            }
            if ((filterValue = instance.getFilter()) != null) {
                this.withFilter(filterValue);
            }
            if ((sortByValue = instance.getSortBy()) != null) {
                this.withSortBy(sortByValue);
            }
            if ((sortOrderValue = instance.getSortOrder()) != null) {
                this.withSortOrder(sortOrderValue);
            }
            if ((startIndexValue = instance.getStartIndex()) != null) {
                this.withStartIndex(startIndexValue);
            }
            if ((countValue = instance.getCount()) != null) {
                this.withCount(countValue);
            }
            return this;
        }

        public final Builder addSchemas(String element) {
            this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addSchemas(String ... elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder withSchemas(Iterable<String> elements) {
            this.schemas.clear();
            return this.addAllSchemas(elements);
        }

        public final Builder addAllSchemas(Iterable<String> elements) {
            for (String element : elements) {
                this.schemas.add(Objects.requireNonNull(element, "schemas element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public final Builder addAttributes(String element) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<String>();
            }
            this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            return this;
        }

        public final Builder addAttributes(String ... elements) {
            if (this.attributes == null) {
                this.attributes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder withAttributes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.attributes = null;
                return this;
            }
            this.attributes = new ArrayList<String>();
            return this.addAllAttributes(elements);
        }

        public final Builder addAllAttributes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "attributes element");
            if (this.attributes == null) {
                this.attributes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.attributes.add(Objects.requireNonNull(element, "attributes element"));
            }
            return this;
        }

        public final Builder addExcludedAttributes(String element) {
            if (this.excludedAttributes == null) {
                this.excludedAttributes = new ArrayList<String>();
            }
            this.excludedAttributes.add(Objects.requireNonNull(element, "excludedAttributes element"));
            return this;
        }

        public final Builder addExcludedAttributes(String ... elements) {
            if (this.excludedAttributes == null) {
                this.excludedAttributes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludedAttributes.add(Objects.requireNonNull(element, "excludedAttributes element"));
            }
            return this;
        }

        public final Builder withExcludedAttributes(@Nullable Iterable<String> elements) {
            if (elements == null) {
                this.excludedAttributes = null;
                return this;
            }
            this.excludedAttributes = new ArrayList<String>();
            return this.addAllExcludedAttributes(elements);
        }

        public final Builder addAllExcludedAttributes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "excludedAttributes element");
            if (this.excludedAttributes == null) {
                this.excludedAttributes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.excludedAttributes.add(Objects.requireNonNull(element, "excludedAttributes element"));
            }
            return this;
        }

        public final Builder withFilter(@Nullable String filter) {
            this.filter = filter;
            return this;
        }

        public final Builder withSortBy(@Nullable String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public final Builder withSortOrder(@Nullable ScimSortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public final Builder withStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
            return this;
        }

        public final Builder withCount(@Nullable Integer count) {
            this.count = count;
            return this;
        }

        public ImmutableScimSearchRequest build() {
            return ImmutableScimSearchRequest.validate(new ImmutableScimSearchRequest(this));
        }

        private boolean schemasIsSet() {
            return (this.optBits & 1L) != 0L;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    static final class Json
    extends ScimSearchRequest {
        List<String> schemas = Collections.emptyList();
        boolean schemasIsSet;
        List<String> attributes = null;
        List<String> excludedAttributes = null;
        @Nullable
        String filter;
        @Nullable
        String sortBy;
        @Nullable
        ScimSortOrder sortOrder;
        @Nullable
        Integer startIndex;
        @Nullable
        Integer count;

        Json() {
        }

        @JsonProperty
        public void setSchemas(List<String> schemas) {
            this.schemas = schemas;
            this.schemasIsSet = true;
        }

        @JsonProperty
        public void setAttributes(@Nullable List<String> attributes) {
            this.attributes = attributes;
        }

        @JsonProperty
        public void setExcludedAttributes(@Nullable List<String> excludedAttributes) {
            this.excludedAttributes = excludedAttributes;
        }

        @JsonProperty
        public void setFilter(@Nullable String filter) {
            this.filter = filter;
        }

        @JsonProperty
        public void setSortBy(@Nullable String sortBy) {
            this.sortBy = sortBy;
        }

        @JsonProperty
        public void setSortOrder(@Nullable ScimSortOrder sortOrder) {
            this.sortOrder = sortOrder;
        }

        @JsonProperty
        public void setStartIndex(@Nullable Integer startIndex) {
            this.startIndex = startIndex;
        }

        @JsonProperty
        public void setCount(@Nullable Integer count) {
            this.count = count;
        }

        @Override
        public List<String> getSchemas() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<String> getExcludedAttributes() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getFilter() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSortBy() {
            throw new UnsupportedOperationException();
        }

        @Override
        public ScimSortOrder getSortOrder() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getStartIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Integer getCount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean shouldHideResources() {
            throw new UnsupportedOperationException();
        }
    }

    private final class InitShim {
        private List<String> schemas;
        private int schemasStage;
        private boolean shouldHideResources;
        private int shouldHideResourcesStage;

        private InitShim() {
        }

        List<String> getSchemas() {
            if (this.schemasStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.schemasStage == 0) {
                this.schemasStage = -1;
                this.schemas = ImmutableScimSearchRequest.createUnmodifiableList(false, ImmutableScimSearchRequest.createSafeList(ImmutableScimSearchRequest.super.getSchemas(), true, false));
                this.schemasStage = 1;
            }
            return this.schemas;
        }

        void withSchemas(List<String> schemas) {
            this.schemas = schemas;
            this.schemasStage = 1;
        }

        boolean shouldHideResources() {
            if (this.shouldHideResourcesStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.shouldHideResourcesStage == 0) {
                this.shouldHideResourcesStage = -1;
                this.shouldHideResources = ImmutableScimSearchRequest.super.shouldHideResources();
                this.shouldHideResourcesStage = 1;
            }
            return this.shouldHideResources;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.schemasStage == -1) {
                attributes.add("schemas");
            }
            if (this.shouldHideResourcesStage == -1) {
                attributes.add("shouldHideResources");
            }
            return "Cannot build ScimSearchRequest, attribute initializers form cycle" + attributes;
        }
    }
}

